/*
 * Decompiled with CFR 0.152.
 */
package arc.input;

import arc.input.InputProcessor;
import arc.input.KeyCode;
import arc.struct.IntFloatMap;
import arc.struct.IntSet;

public class KeyboardDevice
implements InputProcessor {
    private final IntSet pressed = new IntSet();
    private final IntSet justReleased = new IntSet();
    private final IntSet lastFramePressed = new IntSet();
    private final IntSet justPressed = new IntSet();
    private final IntFloatMap axes = new IntFloatMap();

    public void postUpdate() {
        this.lastFramePressed.clear();
        this.lastFramePressed.addAll(this.pressed);
        this.justPressed.clear();
        this.justReleased.clear();
        this.axes.clear();
    }

    public boolean isPressed(KeyCode key) {
        if (key == KeyCode.anyKey) {
            return this.pressed.size > 0;
        }
        return this.pressed.contains(key.ordinal());
    }

    public boolean isTapped(KeyCode key) {
        return this.justPressed.contains(key.ordinal());
    }

    public boolean isReleased(KeyCode key) {
        return this.justReleased.contains(key.ordinal());
    }

    public float getAxis(KeyCode keyCode) {
        return this.axes.get(keyCode.ordinal(), 0.0f);
    }

    @Override
    public boolean keyDown(KeyCode key) {
        this.pressed.add(key.ordinal());
        this.justPressed.add(key.ordinal());
        return false;
    }

    @Override
    public boolean keyUp(KeyCode key) {
        this.pressed.remove(key.ordinal());
        this.justReleased.add(key.ordinal());
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, KeyCode button) {
        this.keyDown(button);
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, KeyCode button) {
        if (pointer == 0) {
            this.keyUp(button);
        }
        return false;
    }

    @Override
    public boolean scrolled(float amountX, float amountY) {
        this.axes.put(KeyCode.scroll.ordinal(), -amountY);
        return false;
    }
}

