/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.gl;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.GLTexture;
import arc.graphics.Gl;
import arc.graphics.Pixmap;
import arc.graphics.g2d.Draw;
import arc.graphics.gl.FloatFrameBuffer;
import arc.graphics.gl.FrameBuffer;
import arc.graphics.gl.FrameBufferCubemap;
import arc.struct.Seq;
import arc.util.ArcRuntimeException;
import arc.util.Buffers;
import arc.util.Disposable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public abstract class GLFrameBuffer<T extends GLTexture>
implements Disposable {
    protected static final int GL_DEPTH24_STENCIL8_OES = 35056;
    protected static GLFrameBuffer<?> currentBoundFramebuffer;
    protected static int defaultFramebufferHandle;
    protected static int bufferNesting;
    protected static boolean defaultFramebufferHandleInitialized;
    protected Seq<T> textureAttachments = new Seq();
    protected GLFrameBuffer<?> lastBoundFramebuffer = null;
    protected int framebufferHandle;
    protected int depthbufferHandle;
    protected int stencilbufferHandle;
    protected int depthStencilPackedBufferHandle;
    protected boolean hasDepthStencilPackedBuffer;
    protected boolean isMRT;
    protected GLFrameBufferBuilder<? extends GLFrameBuffer<T>> bufferBuilder;

    GLFrameBuffer() {
    }

    protected GLFrameBuffer(GLFrameBufferBuilder<? extends GLFrameBuffer<T>> bufferBuilder) {
        this.bufferBuilder = bufferBuilder;
        this.build();
    }

    public static int getBufferNesting() {
        return bufferNesting;
    }

    public static void unbind() {
        Gl.bindFramebuffer(36160, defaultFramebufferHandle);
    }

    public T getTexture() {
        return (T)((GLTexture)this.textureAttachments.first());
    }

    public Seq<T> getTextureAttachments() {
        return this.textureAttachments;
    }

    protected abstract T createTexture(FrameBufferTextureAttachmentSpec var1);

    protected abstract void disposeTexture(T var1);

    protected abstract void attachTexture(int var1, T var2);

    protected void build() {
        this.checkValidBuilder();
        if (!defaultFramebufferHandleInitialized) {
            defaultFramebufferHandleInitialized = true;
            if (Core.app.isIOS()) {
                IntBuffer intbuf = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asIntBuffer();
                Gl.getIntegerv(36006, intbuf);
                defaultFramebufferHandle = intbuf.get(0);
            } else {
                defaultFramebufferHandle = 0;
            }
        }
        int lastHandle = currentBoundFramebuffer == null ? defaultFramebufferHandle : GLFrameBuffer.currentBoundFramebuffer.framebufferHandle;
        this.framebufferHandle = Gl.genFramebuffer();
        Gl.bindFramebuffer(36160, this.framebufferHandle);
        int width = this.bufferBuilder.width;
        int height = this.bufferBuilder.height;
        if (this.bufferBuilder.hasDepthRenderBuffer) {
            this.depthbufferHandle = Gl.genRenderbuffer();
            Gl.bindRenderbuffer(36161, this.depthbufferHandle);
            Gl.renderbufferStorage(36161, this.bufferBuilder.depthRenderBufferSpec.internalFormat, width, height);
        }
        if (this.bufferBuilder.hasStencilRenderBuffer) {
            this.stencilbufferHandle = Gl.genRenderbuffer();
            Gl.bindRenderbuffer(36161, this.stencilbufferHandle);
            Gl.renderbufferStorage(36161, this.bufferBuilder.stencilRenderBufferSpec.internalFormat, width, height);
        }
        if (this.bufferBuilder.hasPackedStencilDepthRenderBuffer) {
            this.depthStencilPackedBufferHandle = Gl.genRenderbuffer();
            Gl.bindRenderbuffer(36161, this.depthStencilPackedBufferHandle);
            Gl.renderbufferStorage(36161, this.bufferBuilder.packedStencilDepthRenderBufferSpec.internalFormat, width, height);
        }
        this.isMRT = this.bufferBuilder.textureAttachmentSpecs.size > 1;
        int colorTextureCounter = 0;
        if (this.isMRT) {
            for (FrameBufferTextureAttachmentSpec attachmentSpec : this.bufferBuilder.textureAttachmentSpecs) {
                Object texture = this.createTexture(attachmentSpec);
                this.textureAttachments.add(texture);
                if (attachmentSpec.isColorTexture()) {
                    this.attachTexture(36064 + colorTextureCounter, texture);
                    ++colorTextureCounter;
                    continue;
                }
                if (attachmentSpec.isDepth) {
                    this.attachTexture(36096, texture);
                    continue;
                }
                if (!attachmentSpec.isStencil) continue;
                this.attachTexture(36128, texture);
            }
        } else {
            T texture = this.createTexture(this.bufferBuilder.textureAttachmentSpecs.first());
            this.textureAttachments.add(texture);
            this.attachTexture(36064, texture);
        }
        if (this.isMRT) {
            IntBuffer buffer = Buffers.newIntBuffer(colorTextureCounter);
            for (int i = 0; i < colorTextureCounter; ++i) {
                buffer.put(36064 + i);
            }
            buffer.position(0);
            Core.gl30.glDrawBuffers(colorTextureCounter, buffer);
        }
        if (this.bufferBuilder.hasDepthRenderBuffer) {
            Gl.framebufferRenderbuffer(36160, 36096, 36161, this.depthbufferHandle);
        }
        if (this.bufferBuilder.hasStencilRenderBuffer) {
            Gl.framebufferRenderbuffer(36160, 36128, 36161, this.stencilbufferHandle);
        }
        if (this.bufferBuilder.hasPackedStencilDepthRenderBuffer) {
            Gl.framebufferRenderbuffer(36160, 33306, 36161, this.depthStencilPackedBufferHandle);
        }
        Gl.bindRenderbuffer(36161, 0);
        for (GLTexture texture : this.textureAttachments) {
            Gl.bindTexture(texture.glTarget, 0);
        }
        int result = Gl.checkFramebufferStatus(36160);
        if (result == 36061 && this.bufferBuilder.hasDepthRenderBuffer && this.bufferBuilder.hasStencilRenderBuffer && (Core.graphics.supportsExtension("GL_OES_packed_depth_stencil") || Core.graphics.supportsExtension("GL_EXT_packed_depth_stencil"))) {
            if (this.bufferBuilder.hasDepthRenderBuffer) {
                Gl.deleteRenderbuffer(this.depthbufferHandle);
                this.depthbufferHandle = 0;
            }
            if (this.bufferBuilder.hasStencilRenderBuffer) {
                Gl.deleteRenderbuffer(this.stencilbufferHandle);
                this.stencilbufferHandle = 0;
            }
            if (this.bufferBuilder.hasPackedStencilDepthRenderBuffer) {
                Gl.deleteRenderbuffer(this.depthStencilPackedBufferHandle);
                this.depthStencilPackedBufferHandle = 0;
            }
            this.depthStencilPackedBufferHandle = Gl.genRenderbuffer();
            this.hasDepthStencilPackedBuffer = true;
            Gl.bindRenderbuffer(36161, this.depthStencilPackedBufferHandle);
            Gl.renderbufferStorage(36161, 35056, width, height);
            Gl.bindRenderbuffer(36161, 0);
            Gl.framebufferRenderbuffer(36160, 36096, 36161, this.depthStencilPackedBufferHandle);
            Gl.framebufferRenderbuffer(36160, 36128, 36161, this.depthStencilPackedBufferHandle);
            result = Gl.checkFramebufferStatus(36160);
        }
        Gl.bindFramebuffer(36160, lastHandle);
        if (result != 36053) {
            for (Object texture : this.textureAttachments) {
                this.disposeTexture(texture);
            }
            if (this.hasDepthStencilPackedBuffer) {
                Gl.deleteBuffer(this.depthStencilPackedBufferHandle);
            } else {
                if (this.bufferBuilder.hasDepthRenderBuffer) {
                    Gl.deleteRenderbuffer(this.depthbufferHandle);
                }
                if (this.bufferBuilder.hasStencilRenderBuffer) {
                    Gl.deleteRenderbuffer(this.stencilbufferHandle);
                }
            }
            Gl.deleteFramebuffer(this.framebufferHandle);
            if (result == 36054) {
                throw new IllegalStateException("Frame buffer couldn't be constructed: incomplete attachment (" + width + "x" + height + ")");
            }
            if (result == 36057) {
                throw new IllegalStateException("Frame buffer couldn't be constructed: incomplete dimensions");
            }
            if (result == 36055) {
                throw new IllegalStateException("Frame buffer couldn't be constructed: missing attachment");
            }
            if (result == 36061) {
                throw new IllegalStateException("Frame buffer couldn't be constructed: unsupported combination of formats");
            }
            throw new IllegalStateException("Frame buffer couldn't be constructed: unknown error " + result);
        }
    }

    private void checkValidBuilder() {
        boolean runningGL30 = Core.graphics.isGL30Available();
        if (!runningGL30) {
            if (this.bufferBuilder.hasPackedStencilDepthRenderBuffer) {
                throw new ArcRuntimeException("Packed Stencil/Render render buffers are not available on GLES 2.0");
            }
            if (this.bufferBuilder.textureAttachmentSpecs.size > 1) {
                throw new ArcRuntimeException("Multiple render targets not available on GLES 2.0");
            }
            for (FrameBufferTextureAttachmentSpec spec : this.bufferBuilder.textureAttachmentSpecs) {
                if (spec.isDepth) {
                    throw new ArcRuntimeException("Depth texture FrameBuffer Attachment not available on GLES 2.0");
                }
                if (spec.isStencil) {
                    throw new ArcRuntimeException("Stencil texture FrameBuffer Attachment not available on GLES 2.0");
                }
                if (!spec.isFloat || Core.graphics.supportsExtension("OES_texture_float")) continue;
                throw new ArcRuntimeException("Float texture FrameBuffer Attachment not available on GLES 2.0");
            }
        }
    }

    @Override
    public void dispose() {
        for (GLTexture texture : this.textureAttachments) {
            this.disposeTexture(texture);
        }
        if (this.hasDepthStencilPackedBuffer) {
            Gl.deleteRenderbuffer(this.depthStencilPackedBufferHandle);
        } else {
            if (this.bufferBuilder.hasDepthRenderBuffer) {
                Gl.deleteRenderbuffer(this.depthbufferHandle);
            }
            if (this.bufferBuilder.hasStencilRenderBuffer) {
                Gl.deleteRenderbuffer(this.stencilbufferHandle);
            }
        }
        Gl.deleteFramebuffer(this.framebufferHandle);
    }

    public void bind() {
        Gl.bindFramebuffer(36160, this.framebufferHandle);
    }

    public boolean isBound() {
        return currentBoundFramebuffer == this;
    }

    public void begin(Color clearColor) {
        this.begin();
        Gl.clearColor(clearColor.r, clearColor.g, clearColor.b, clearColor.a);
        Gl.clear(this.depthbufferHandle != 0 ? 16640 : 16384);
    }

    public void begin() {
        Draw.flush();
        this.beginBind();
        this.setFrameBufferViewport();
    }

    public void beginBind() {
        if (currentBoundFramebuffer == this) {
            throw new IllegalArgumentException("Do not begin() twice.");
        }
        this.lastBoundFramebuffer = currentBoundFramebuffer;
        currentBoundFramebuffer = this;
        ++bufferNesting;
        this.bind();
    }

    protected void setFrameBufferViewport() {
        Gl.viewport(0, 0, this.bufferBuilder.width, this.bufferBuilder.height);
    }

    public void end() {
        Draw.flush();
        if (this.lastBoundFramebuffer != null) {
            this.lastBoundFramebuffer.bind();
            this.lastBoundFramebuffer.setFrameBufferViewport();
        } else {
            GLFrameBuffer.unbind();
            Gl.viewport(0, 0, Core.graphics.getBackBufferWidth(), Core.graphics.getBackBufferHeight());
        }
        --bufferNesting;
        currentBoundFramebuffer = this.lastBoundFramebuffer;
        this.lastBoundFramebuffer = null;
    }

    public void endBind() {
        if (this.lastBoundFramebuffer != null) {
            this.lastBoundFramebuffer.bind();
        } else {
            GLFrameBuffer.unbind();
        }
        --bufferNesting;
        currentBoundFramebuffer = this.lastBoundFramebuffer;
        this.lastBoundFramebuffer = null;
    }

    public int getFramebufferHandle() {
        return this.framebufferHandle;
    }

    public int getDepthBufferHandle() {
        return this.depthbufferHandle;
    }

    public int getStencilBufferHandle() {
        return this.stencilbufferHandle;
    }

    protected int getDepthStencilPackedBuffer() {
        return this.depthStencilPackedBufferHandle;
    }

    public int getHeight() {
        return this.bufferBuilder.height;
    }

    public int getWidth() {
        return this.bufferBuilder.width;
    }

    static {
        defaultFramebufferHandleInitialized = false;
    }

    protected static abstract class GLFrameBufferBuilder<U extends GLFrameBuffer<? extends GLTexture>> {
        protected int width;
        protected int height;
        protected Seq<FrameBufferTextureAttachmentSpec> textureAttachmentSpecs = new Seq();
        protected FrameBufferRenderBufferAttachmentSpec stencilRenderBufferSpec;
        protected FrameBufferRenderBufferAttachmentSpec depthRenderBufferSpec;
        protected FrameBufferRenderBufferAttachmentSpec packedStencilDepthRenderBufferSpec;
        protected boolean hasStencilRenderBuffer;
        protected boolean hasDepthRenderBuffer;
        protected boolean hasPackedStencilDepthRenderBuffer;

        public GLFrameBufferBuilder(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public GLFrameBufferBuilder<U> addColorTextureAttachment(int internalFormat, int format, int type) {
            this.textureAttachmentSpecs.add(new FrameBufferTextureAttachmentSpec(internalFormat, format, type));
            return this;
        }

        public GLFrameBufferBuilder<U> addBasicColorTextureAttachment(Pixmap.Format format) {
            int glFormat = format.glFormat;
            int glType = format.glType;
            return this.addColorTextureAttachment(glFormat, glFormat, glType);
        }

        public GLFrameBufferBuilder<U> addFloatAttachment(int internalFormat, int format, int type, boolean gpuOnly) {
            FrameBufferTextureAttachmentSpec spec = new FrameBufferTextureAttachmentSpec(internalFormat, format, type);
            spec.isFloat = true;
            spec.isGpuOnly = gpuOnly;
            this.textureAttachmentSpecs.add(spec);
            return this;
        }

        public GLFrameBufferBuilder<U> addDepthTextureAttachment(int internalFormat, int type) {
            FrameBufferTextureAttachmentSpec spec = new FrameBufferTextureAttachmentSpec(internalFormat, 6402, type);
            spec.isDepth = true;
            this.textureAttachmentSpecs.add(spec);
            return this;
        }

        public GLFrameBufferBuilder<U> addStencilTextureAttachment(int internalFormat, int type) {
            FrameBufferTextureAttachmentSpec spec = new FrameBufferTextureAttachmentSpec(internalFormat, 36128, type);
            spec.isStencil = true;
            this.textureAttachmentSpecs.add(spec);
            return this;
        }

        public GLFrameBufferBuilder<U> addDepthRenderBuffer(int internalFormat) {
            this.depthRenderBufferSpec = new FrameBufferRenderBufferAttachmentSpec(internalFormat);
            this.hasDepthRenderBuffer = true;
            return this;
        }

        public GLFrameBufferBuilder<U> addStencilRenderBuffer(int internalFormat) {
            this.stencilRenderBufferSpec = new FrameBufferRenderBufferAttachmentSpec(internalFormat);
            this.hasStencilRenderBuffer = true;
            return this;
        }

        public GLFrameBufferBuilder<U> addStencilDepthPackedRenderBuffer(int internalFormat) {
            this.packedStencilDepthRenderBufferSpec = new FrameBufferRenderBufferAttachmentSpec(internalFormat);
            this.hasPackedStencilDepthRenderBuffer = true;
            return this;
        }

        public GLFrameBufferBuilder<U> addBasicDepthRenderBuffer() {
            return this.addDepthRenderBuffer(33189);
        }

        public GLFrameBufferBuilder<U> addBasicStencilRenderBuffer() {
            return this.addStencilRenderBuffer(36168);
        }

        public GLFrameBufferBuilder<U> addBasicStencilDepthPackedRenderBuffer() {
            return this.addStencilDepthPackedRenderBuffer(35056);
        }

        public abstract U build();
    }

    protected static class FrameBufferRenderBufferAttachmentSpec {
        int internalFormat;

        public FrameBufferRenderBufferAttachmentSpec(int internalFormat) {
            this.internalFormat = internalFormat;
        }
    }

    protected static class FrameBufferTextureAttachmentSpec {
        int internalFormat;
        int format;
        int type;
        boolean isFloat;
        boolean isGpuOnly;
        boolean isDepth;
        boolean isStencil;

        public FrameBufferTextureAttachmentSpec(int internalformat, int format, int type) {
            this.internalFormat = internalformat;
            this.format = format;
            this.type = type;
        }

        public boolean isColorTexture() {
            return !this.isDepth && !this.isStencil;
        }
    }

    public static class FrameBufferCubemapBuilder
    extends GLFrameBufferBuilder<FrameBufferCubemap> {
        public FrameBufferCubemapBuilder(int width, int height) {
            super(width, height);
        }

        @Override
        public FrameBufferCubemap build() {
            return new FrameBufferCubemap(this);
        }
    }

    public static class FloatFrameBufferBuilder
    extends GLFrameBufferBuilder<FloatFrameBuffer> {
        public FloatFrameBufferBuilder(int width, int height) {
            super(width, height);
        }

        @Override
        public FloatFrameBuffer build() {
            return new FloatFrameBuffer(this);
        }
    }

    public static class FrameBufferBuilder
    extends GLFrameBufferBuilder<FrameBuffer> {
        public FrameBufferBuilder(int width, int height) {
            super(width, height);
        }

        @Override
        public FrameBuffer build() {
            return new FrameBuffer(this);
        }
    }
}

