/*
 * Decompiled with CFR 0.152.
 */
package arc.fx;

import arc.Core;
import arc.func.Boolf;
import arc.fx.FxFilter;
import arc.fx.util.FxBufferRenderer;
import arc.fx.util.PingPongBuffer;
import arc.graphics.Color;
import arc.graphics.Gl;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.gl.FrameBuffer;
import arc.struct.ObjectIntMap;
import arc.struct.Seq;
import arc.util.Disposable;

public final class FxProcessor
implements Disposable {
    private final ObjectIntMap<FxFilter> priorities = new ObjectIntMap();
    private final Seq<FxFilter> effectsAll = new Seq();
    private final Seq<FxFilter> effectsEnabled = new Seq();
    private final FxBufferRenderer bufferRenderer = new FxBufferRenderer();
    private final Pixmap.Format fboFormat;
    private final PingPongBuffer pingPongBuffer;
    private boolean disabled = false;
    private boolean capturing = false;
    private boolean hasCaptured = false;
    private boolean applyingEffects = false;
    private boolean blendingEnabled = false;
    private int width;
    private int height;

    public FxProcessor() {
        this(Pixmap.Format.rgba8888, Core.graphics.getBackBufferWidth(), Core.graphics.getBackBufferHeight());
    }

    public FxProcessor(int w, int h) {
        this(Pixmap.Format.rgba8888, w, h);
    }

    public FxProcessor(Pixmap.Format fboFormat, int bufferWidth, int bufferHeight) {
        this(fboFormat, bufferWidth, bufferHeight, false, false);
    }

    public FxProcessor(Pixmap.Format fboFormat, int bufferWidth, int bufferHeight, boolean depth, boolean stencil) {
        this.fboFormat = fboFormat;
        this.pingPongBuffer = new PingPongBuffer(fboFormat, bufferWidth, bufferHeight, depth, stencil);
        this.width = bufferWidth;
        this.height = bufferHeight;
    }

    @Override
    public void dispose() {
        this.pingPongBuffer.dispose();
    }

    public void resize(int width, int height) {
        if (this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            this.pingPongBuffer.resize(width, height);
            for (FxFilter filter : this.effectsAll) {
                filter.resize(width, height);
                filter.rebind();
            }
        }
    }

    public void rebind() {
        this.bufferRenderer.rebind();
        for (FxFilter filter : this.effectsAll) {
            filter.rebind();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isBlendingEnabled() {
        return this.blendingEnabled;
    }

    public void setBlendingEnabled(boolean blendingEnabled) {
        this.blendingEnabled = blendingEnabled;
    }

    public Pixmap.Format getFramebufferFormat() {
        return this.fboFormat;
    }

    public void setBufferTextureParams(Texture.TextureWrap u, Texture.TextureWrap v, Texture.TextureFilter min, Texture.TextureFilter mag) {
        this.pingPongBuffer.setTextureParams(u, v, min, mag);
    }

    public void setTextureFilter(Texture.TextureFilter filter) {
        this.setBufferTextureParams(Texture.TextureWrap.clampToEdge, Texture.TextureWrap.clampToEdge, filter, filter);
    }

    public boolean isCapturing() {
        return this.capturing;
    }

    public boolean isApplyingEffects() {
        return this.applyingEffects;
    }

    public boolean hasResult() {
        return this.hasCaptured;
    }

    public FrameBuffer getResultBuffer() {
        return this.pingPongBuffer.getDstBuffer();
    }

    public PingPongBuffer getPingPongBuffer() {
        return this.pingPongBuffer;
    }

    public boolean hasEnabledEffects() {
        return this.effectsAll.contains((FxFilter)((Object)((Boolf<FxFilter>)fx -> !fx.isDisabled())));
    }

    public void addEffect(FxFilter effect) {
        this.addEffect(effect, 0);
    }

    public void addEffect(FxFilter effect, int priority) {
        this.effectsAll.add(effect);
        this.priorities.put(effect, priority);
        this.effectsAll.sort(e -> this.priorities.get(effect, 0));
        effect.resize(this.width, this.height);
        effect.rebind();
    }

    public void removeEffect(FxFilter effect) {
        this.effectsAll.remove(effect);
    }

    public void removeAllEffects() {
        this.effectsAll.clear();
    }

    public void setEffectPriority(FxFilter effect, int priority) {
        this.priorities.put(effect, priority);
        this.effectsAll.sort(e -> this.priorities.get(effect, 0));
    }

    public void clear() {
        this.clear(Color.clear);
    }

    public void clear(Color color) {
        if (this.capturing) {
            throw new IllegalStateException("Cannot clean up buffers when capturing.");
        }
        if (this.applyingEffects) {
            throw new IllegalStateException("Cannot clean up buffers when applying effects.");
        }
        this.pingPongBuffer.clear(color);
        this.hasCaptured = false;
    }

    public boolean begin() {
        if (this.applyingEffects) {
            throw new IllegalStateException("You cannot capture when you're applying the effects.");
        }
        if (this.disabled) {
            return false;
        }
        if (this.capturing) {
            return false;
        }
        Draw.flush();
        this.capturing = true;
        this.pingPongBuffer.begin();
        return true;
    }

    public boolean end() {
        if (!this.capturing) {
            return false;
        }
        Draw.flush();
        this.hasCaptured = true;
        this.capturing = false;
        this.pingPongBuffer.end();
        return true;
    }

    public void applyEffects() {
        if (this.capturing) {
            throw new IllegalStateException("You should call VfxManager.endCapture() before applying the effects.");
        }
        if (this.disabled) {
            return;
        }
        if (!this.hasCaptured) {
            return;
        }
        this.effectsAll.each(FxFilter::update);
        Seq<FxFilter> effectChain = this.effectsEnabled.selectFrom(this.effectsAll, e -> !e.isDisabled());
        this.applyingEffects = true;
        int count = effectChain.size;
        if (count > 0) {
            if (this.blendingEnabled) {
                Gl.enable(3042);
            } else {
                Gl.disable(3042);
            }
            Gl.disable(2884);
            Gl.disable(2929);
            this.pingPongBuffer.swap();
            this.pingPongBuffer.begin();
            for (int i = 0; i < count; ++i) {
                FxFilter effect = effectChain.get(i);
                effect.render(this.pingPongBuffer.getSrcBuffer(), this.pingPongBuffer.getDstBuffer());
                if (i >= count - 1) continue;
                this.pingPongBuffer.swap();
            }
            this.pingPongBuffer.end();
            Gl.activeTexture(33984);
            if (this.blendingEnabled) {
                Gl.disable(3042);
            }
        }
        this.applyingEffects = false;
    }

    public void render() {
        if (this.capturing) {
            throw new IllegalStateException("You should call VfxManager.endCapture() before rendering the result.");
        }
        if (this.disabled) {
            return;
        }
        if (!this.hasCaptured) {
            return;
        }
        if (this.blendingEnabled) {
            Gl.enable(3042);
        } else {
            Gl.disable(3042);
        }
        this.bufferRenderer.renderToScreen(this.pingPongBuffer.getDstBuffer());
        if (this.blendingEnabled) {
            Gl.disable(3042);
        }
    }

    public void render(int x, int y, int width, int height) {
        if (this.capturing) {
            throw new IllegalStateException("You should call VfxManager.endCapture() before rendering the result.");
        }
        if (this.disabled) {
            return;
        }
        if (!this.hasCaptured) {
            return;
        }
        if (this.blendingEnabled) {
            Gl.enable(3042);
        }
        this.bufferRenderer.renderToScreen(this.pingPongBuffer.getDstBuffer(), x, y, width, height);
        if (this.blendingEnabled) {
            Gl.disable(3042);
        }
    }

    public void render(FrameBuffer output) {
        if (this.capturing) {
            throw new IllegalStateException("You should call VfxManager.endCapture() before rendering the result.");
        }
        if (this.disabled) {
            return;
        }
        if (!this.hasCaptured) {
            return;
        }
        if (this.blendingEnabled) {
            Gl.enable(3042);
        }
        this.bufferRenderer.renderToFbo(this.pingPongBuffer.getDstBuffer(), output);
        if (this.blendingEnabled) {
            Gl.disable(3042);
        }
    }
}

