/*
 * Decompiled with CFR 0.152.
 */
package arc.files;

import arc.Files;
import arc.files.Fi;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.ArcRuntimeException;
import arc.util.Log;
import arc.util.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFi
extends Fi {
    @Nullable
    private ZipFi[] children;
    @Nullable
    private ZipFi parent;
    private String path;
    private Seq<ZipFi> allFiles;
    private Seq<ZipFi> allDirectories;
    @Nullable
    private final ZipEntry entry;
    private final ZipFile zip;

    public ZipFi(Fi zipFileLoc) {
        super(new File(""), Files.FileType.absolute);
        this.entry = null;
        try {
            this.zip = new ZipFile(zipFileLoc.file());
            this.path = "";
            Seq<? extends ZipEntry> entries = Seq.with(Collections.list(this.zip.entries()));
            ObjectMap byName = new ObjectMap();
            entries.each(e -> byName.put(e.getName(), e));
            Seq<String> names = entries.map((T z) -> z.getName().replace('\\', '/'));
            ObjectSet<String> paths = new ObjectSet<String>();
            for (String path : names) {
                paths.add(path);
                while (path.contains("/") && !path.equals("/") && path.substring(0, path.length() - 1).contains("/")) {
                    int index = path.endsWith("/") ? path.substring(0, path.length() - 1).lastIndexOf(47) : path.lastIndexOf(47);
                    path = path.substring(0, index);
                    paths.add(path.endsWith("/") ? path : path + "/");
                }
            }
            if (paths.contains("/")) {
                this.file = new File("/");
                paths.remove("/");
            }
            this.allFiles = new Seq();
            this.allDirectories = new Seq();
            for (String s : paths) {
                ZipEntry entry = (ZipEntry)byName.get(s);
                ZipFi file = entry != null ? new ZipFi(entry, this.zip, this.allFiles, this.allDirectories) : new ZipFi(s, this.zip, this.allFiles, this.allDirectories);
                this.allFiles.add(file);
                if (!file.isDirectory()) continue;
                this.allDirectories.add(file);
            }
            this.allFiles.add(this);
            this.allDirectories.add(this);
            this.parent = null;
        }
        catch (IOException e2) {
            throw new ArcRuntimeException(e2);
        }
    }

    private static int countSlashes(String str) {
        int sum = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '/') continue;
            ++sum;
        }
        return sum;
    }

    private ZipFi(ZipEntry entry, ZipFile file, Seq<ZipFi> allFiles, Seq<ZipFi> allDirectories) {
        super(new File(entry.getName()), Files.FileType.absolute);
        this.allDirectories = allDirectories;
        this.allFiles = allFiles;
        this.path = entry.getName().replace('\\', '/');
        this.entry = entry;
        this.zip = file;
    }

    private ZipFi(String path, ZipFile file, Seq<ZipFi> allFiles, Seq<ZipFi> allDirectories) {
        super(new File(path), Files.FileType.absolute);
        this.allDirectories = allDirectories;
        this.allFiles = allFiles;
        this.path = path.replace('\\', '/');
        this.entry = null;
        this.zip = file;
    }

    @Override
    public boolean delete() {
        try {
            this.zip.close();
            return true;
        }
        catch (IOException e) {
            Log.err(e);
            return false;
        }
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public Fi child(String name) {
        this.list();
        for (ZipFi child : this.children) {
            if (!child.name().equals(name)) continue;
            return child;
        }
        return new Fi(new File(this.file, name)){

            @Override
            public boolean exists() {
                return false;
            }
        };
    }

    @Override
    public String name() {
        return this.file.getName();
    }

    @Override
    public String path() {
        return this.path;
    }

    private static boolean isChild(ZipFi file, ZipFi dir) {
        return dir != file && file.path().startsWith(dir.path()) && (file.path().substring(1 + dir.path().length()).indexOf(47) == -1 || file.path().endsWith("/") && ZipFi.countSlashes(file.path().substring(1 + dir.path().length())) == 1);
    }

    @Override
    public Fi parent() {
        if (this.path.length() == 0) {
            return null;
        }
        if (this.parent == null) {
            this.parent = this.allDirectories.find(other -> ZipFi.isChild(this, other));
        }
        return this.parent;
    }

    @Override
    public Fi[] list() {
        if (this.children == null) {
            this.children = (ZipFi[])this.allFiles.select(f -> f.parent == this || ZipFi.isChild(f, this)).toArray(ZipFi.class);
        }
        return this.children;
    }

    @Override
    public boolean isDirectory() {
        return this.entry == null || this.entry.isDirectory();
    }

    @Override
    public InputStream read() {
        if (this.entry == null) {
            throw new RuntimeException("Not permitted.");
        }
        try {
            return this.zip.getInputStream(this.entry);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long length() {
        return this.isDirectory() ? 0L : this.entry.getSize();
    }

    @Override
    public String toString() {
        return this.path();
    }
}

