/*
 * Decompiled with CFR 0.152.
 */
package arc.audio;

import arc.Core;
import arc.audio.AudioFilter;
import arc.audio.Soloud;
import arc.util.Disposable;
import arc.util.Nullable;

public abstract class AudioSource
implements Disposable {
    protected long handle;

    public void setFilter(int index, @Nullable AudioFilter filter) {
        if (this.handle == 0L) {
            return;
        }
        Soloud.sourceFilter(this.handle, index, filter == null ? 0L : filter.handle);
    }

    public void setFilter(@Nullable AudioFilter filter) {
        this.setFilter(0, filter);
    }

    public void setPriority(float priority) {
        if (this.handle == 0L) {
            return;
        }
        Soloud.sourcePriority(this.handle, priority);
    }

    public void setMaxConcurrent(int max) {
        if (this.handle == 0L) {
            return;
        }
        Soloud.sourceMaxConcurrent(this.handle, max);
    }

    public void setConcurrentGroup(int group) {
        if (this.handle == 0L) {
            return;
        }
        Soloud.sourceConcurrentGroup(this.handle, group);
    }

    public void setMinConcurrentInterrupt(float seconds) {
        if (this.handle == 0L) {
            return;
        }
        Soloud.sourceMinConcurrentInterrupt(this.handle, seconds);
    }

    public int countPlaying() {
        if (this.handle == 0L) {
            return 0;
        }
        return Core.audio.countPlaying(this);
    }

    public void setSingleInstance(boolean singleInstance) {
        if (this.handle == 0L || !Core.audio.initialized) {
            return;
        }
        Soloud.sourceSingleInstance(this.handle, singleInstance);
    }

    @Override
    public void dispose() {
    }
}

