/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type.ammo;

import arc.graphics.Color;
import mindustry.content.Fx;
import mindustry.entities.Units;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.type.AmmoType;

public class PowerAmmoType
implements AmmoType {
    public float range = 85.0f;
    public float totalPower = 1000.0f;

    public PowerAmmoType(float totalPower) {
        this.totalPower = totalPower;
    }

    public PowerAmmoType() {
    }

    @Override
    public String icon() {
        return "\ue810";
    }

    @Override
    public Color color() {
        return Pal.powerLight;
    }

    @Override
    public Color barColor() {
        return Pal.powerLight;
    }

    @Override
    public void resupply(Unit unit) {
        float powerPerAmmo;
        float ammoRequired;
        float powerRequired;
        float amount;
        float powerTaken;
        float range = unit.hitSize + this.range;
        Building build = Units.closestBuilding(unit.team, unit.x, unit.y, range, u -> u.block.consPower != null && u.block.consPower.buffered);
        if (build != null && (powerTaken = Math.min(amount = build.power.status * build.block.consPower.capacity, powerRequired = (ammoRequired = (float)unit.type.ammoCapacity - unit.ammo) * (powerPerAmmo = this.totalPower / (float)unit.type.ammoCapacity))) > 1.0f) {
            build.power.status -= powerTaken / build.block.consPower.capacity;
            unit.ammo += powerTaken / powerPerAmmo;
            Fx.itemTransfer.at(build.x, build.y, Math.max(powerTaken / 100.0f, 1.0f), Pal.power, unit);
        }
    }
}

