/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import arc.func.Boolf;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.ui.MultiReqImage;
import mindustry.ui.ReqImage;
import mindustry.world.Block;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;
import mindustry.world.meta.Stats;

public class ConsumeItemFilter
extends Consume {
    public Boolf<Item> filter = i -> false;

    public ConsumeItemFilter(Boolf<Item> item) {
        this.filter = item;
    }

    public ConsumeItemFilter() {
    }

    @Override
    public void apply(Block block) {
        block.hasItems = true;
        block.acceptsItems = true;
        Vars.content.items().each(this.filter, item -> {
            block.itemFilter[item.id] = true;
        });
    }

    @Override
    public void build(Building build, Table table) {
        MultiReqImage image = new MultiReqImage();
        Vars.content.items().each(i -> this.filter.get((Item)i) && i.unlockedNow() && !i.hidden, item -> image.add(new ReqImage((Element)StatValues.stack(item, 1), () -> build.items.has((Item)item))));
        table.add(image).size(32.0f);
    }

    @Override
    public void update(Building build) {
    }

    @Override
    public void trigger(Building build) {
        Item item = this.getConsumed(build);
        if (item != null) {
            build.items.remove(item, 1);
        }
    }

    @Override
    public float efficiency(Building build) {
        return build.consumeTriggerValid() || this.getConsumed(build) != null ? 1.0f : 0.0f;
    }

    @Nullable
    public Item getConsumed(Building build) {
        for (int i = 0; i < Vars.content.items().size; ++i) {
            Item item = Vars.content.item(i);
            if (!build.items.has(item) || !this.filter.get(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public void display(Stats stats) {
        stats.add(this.booster ? Stat.booster : Stat.input, StatValues.items(stats.timePeriod, this.filter));
    }

    @Override
    public float efficiencyMultiplier(Building build) {
        Item item = this.getConsumed(build);
        return item == null ? 0.0f : this.itemEfficiencyMultiplier(item);
    }

    public float itemEfficiencyMultiplier(Item item) {
        return 1.0f;
    }
}

