/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Eachable;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.blocks.power.PowerGraph;
import mindustry.world.meta.BlockGroup;

public class PowerDiode
extends Block {
    public TextureRegion arrow;

    public PowerDiode(String name) {
        super(name);
        this.rotate = true;
        this.update = true;
        this.solid = true;
        this.insulated = true;
        this.group = BlockGroup.power;
        this.noUpdateDisabled = true;
        this.schematicPriority = 10;
        this.envEnabled |= 2;
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("back", entity -> new Bar("bar.input", Pal.powerBar, () -> this.bar(entity.back())));
        this.addBar("front", entity -> new Bar("bar.output", Pal.powerBar, () -> this.bar(entity.front())));
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect(this.fullIcon, plan.drawx(), plan.drawy());
        Draw.rect(this.arrow, plan.drawx(), plan.drawy(), !this.rotate ? 0.0f : (float)(plan.rotation * 90));
    }

    public float bar(Building tile) {
        return tile != null && tile.block.hasPower ? tile.power.graph.getLastPowerStored() / tile.power.graph.getTotalBatteryCapacity() : 0.0f;
    }

    public class PowerDiodeBuild
    extends Building {
        @Override
        public void draw() {
            Draw.rect(PowerDiode.this.region, this.x, this.y, 0.0f);
            Draw.rect(PowerDiode.this.arrow, this.x, this.y, PowerDiode.this.rotate ? this.rotdeg() : 0.0f);
        }

        @Override
        public void updateTile() {
            float frontCapacity;
            float frontStored;
            float backCapacity;
            super.updateTile();
            if (this.tile == null || this.front() == null || this.back() == null || !this.back().block.hasPower || !this.front().block.hasPower || this.back().team != this.team || this.front().team != this.team) {
                return;
            }
            PowerGraph backGraph = this.back().power.graph;
            PowerGraph frontGraph = this.front().power.graph;
            if (backGraph == frontGraph) {
                return;
            }
            float backStored = backGraph.getBatteryStored();
            if (backStored / (backCapacity = backGraph.getTotalBatteryCapacity()) <= (frontStored = frontGraph.getBatteryStored()) / (frontCapacity = frontGraph.getTotalBatteryCapacity())) {
                return;
            }
            float targetPercentage = (frontStored + backStored) / (frontCapacity + backCapacity);
            float amount = (targetPercentage * frontCapacity - frontStored) / 2.0f;
            amount = Mathf.clamp(amount, 0.0f, frontCapacity - frontStored);
            backGraph.transferPower(-amount);
            frontGraph.transferPower(amount);
        }
    }
}

