/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.EnumSet;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.game.EventType;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.ui.Bar;
import mindustry.world.blocks.heat.HeatBlock;
import mindustry.world.blocks.power.PowerGenerator;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class NuclearReactor
extends PowerGenerator {
    public final int timerFuel;
    public Color lightColor;
    public Color coolColor;
    public Color hotColor;
    public float itemDuration;
    public float heating;
    public float heatOutput;
    public float heatWarmupRate;
    public float smokeThreshold;
    public float flashThreshold;
    public float coolantPower;
    public Item fuelItem;
    public TextureRegion topRegion;
    public TextureRegion lightsRegion;

    public NuclearReactor(String name) {
        super(name);
        this.timerFuel = this.timers++;
        this.lightColor = Color.valueOf("7f19ea");
        this.coolColor = new Color(1.0f, 1.0f, 1.0f, 0.0f);
        this.hotColor = Color.valueOf("ff9575a3");
        this.itemDuration = 120.0f;
        this.heating = 0.01f;
        this.heatOutput = 10.0f;
        this.heatWarmupRate = 1.0f;
        this.smokeThreshold = 0.3f;
        this.flashThreshold = 0.46f;
        this.coolantPower = 0.5f;
        this.fuelItem = Items.thorium;
        this.itemCapacity = 30;
        this.liquidCapacity = 30.0f;
        this.hasItems = true;
        this.hasLiquids = true;
        this.rebuildable = false;
        this.emitLight = true;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.reactor, BlockFlag.generator});
        this.schematicPriority = -5;
        this.envEnabled = -1;
        this.explosionShake = 6.0f;
        this.explosionShakeDuration = 16.0f;
        this.explosionRadius = 19;
        this.explosionDamage = 5000;
        this.explodeEffect = Fx.reactorExplosion;
        this.explodeSound = Sounds.explosionbig;
    }

    @Override
    public void setStats() {
        super.setStats();
        if (this.hasItems) {
            this.stats.add(Stat.productionTime, this.itemDuration / 60.0f, StatUnit.seconds);
        }
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("heat", entity -> new Bar("bar.heat", Pal.lightOrange, () -> entity.heat));
    }

    public class NuclearReactorBuild
    extends PowerGenerator.GeneratorBuild
    implements HeatBlock {
        public float heat;
        public float heatProgress;
        public float flash;
        public float smoothLight;

        public NuclearReactorBuild() {
            super(NuclearReactor.this);
        }

        @Override
        public void updateTile() {
            float smoke;
            float fullness;
            int fuel = this.items.get(NuclearReactor.this.fuelItem);
            this.productionEfficiency = fullness = (float)fuel / (float)NuclearReactor.this.itemCapacity;
            if (fuel > 0 && this.enabled) {
                this.heat += fullness * NuclearReactor.this.heating * Math.min(this.delta(), 4.0f);
                if (this.timer(NuclearReactor.this.timerFuel, NuclearReactor.this.itemDuration / this.timeScale)) {
                    this.consume();
                }
            } else {
                this.productionEfficiency = 0.0f;
            }
            if (this.heat > 0.0f) {
                float maxUsed = Math.min(this.liquids.currentAmount(), this.heat / NuclearReactor.this.coolantPower);
                this.heat -= maxUsed * NuclearReactor.this.coolantPower;
                this.liquids.remove(this.liquids.current(), maxUsed);
            }
            if (this.heat > NuclearReactor.this.smokeThreshold && Mathf.chance((double)(smoke = 1.0f + (this.heat - NuclearReactor.this.smokeThreshold) / (1.0f - NuclearReactor.this.smokeThreshold)) / 20.0 * (double)this.delta())) {
                Fx.reactorsmoke.at(this.x + Mathf.range((float)(NuclearReactor.this.size * 8) / 2.0f), this.y + Mathf.range((float)(NuclearReactor.this.size * 8) / 2.0f));
            }
            this.heat = Mathf.clamp(this.heat);
            float f = this.heatProgress = NuclearReactor.this.heatOutput > 0.0f ? Mathf.approachDelta(this.heatProgress, this.heat * NuclearReactor.this.heatOutput * this.efficiency, NuclearReactor.this.heatWarmupRate * this.delta()) : 0.0f;
            if (this.heat >= 0.999f) {
                Events.fire(EventType.Trigger.thoriumReactorOverheat);
                this.kill();
            }
        }

        @Override
        public float heatFrac() {
            return this.heatProgress / NuclearReactor.this.heatOutput;
        }

        @Override
        public float heat() {
            return this.heatProgress;
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.heat) {
                return this.heat;
            }
            return super.sense(sensor);
        }

        @Override
        public boolean shouldExplode() {
            return super.shouldExplode() && (this.items.get(NuclearReactor.this.fuelItem) >= 5 || this.heat >= 0.5f);
        }

        @Override
        public void drawLight() {
            float fract = this.productionEfficiency;
            this.smoothLight = Mathf.lerpDelta(this.smoothLight, fract, 0.08f);
            Drawf.light(this.x, this.y, (90.0f + Mathf.absin(5.0f, 5.0f)) * this.smoothLight, Tmp.c1.set(NuclearReactor.this.lightColor).lerp(Color.scarlet, this.heat), 0.6f * this.smoothLight);
        }

        @Override
        public void draw() {
            super.draw();
            Draw.color(NuclearReactor.this.coolColor, NuclearReactor.this.hotColor, this.heat);
            Fill.rect(this.x, this.y, NuclearReactor.this.size * 8, NuclearReactor.this.size * 8);
            Draw.color(this.liquids.current().color);
            Draw.alpha(this.liquids.currentAmount() / NuclearReactor.this.liquidCapacity);
            Draw.rect(NuclearReactor.this.topRegion, this.x, this.y);
            if (this.heat > NuclearReactor.this.flashThreshold) {
                this.flash += (1.0f + (this.heat - NuclearReactor.this.flashThreshold) / (1.0f - NuclearReactor.this.flashThreshold) * 5.4f) * Time.delta;
                Draw.color(Color.red, Color.yellow, Mathf.absin(this.flash, 9.0f, 1.0f));
                Draw.alpha(0.3f);
                Draw.rect(NuclearReactor.this.lightsRegion, this.x, this.y);
            }
            Draw.reset();
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.heat);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.heat = read.f();
        }
    }
}

