/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.struct.Seq;
import arc.util.Log;
import arc.util.OS;
import java.util.Locale;

public class GpuDetect {
    public static String rawGpuString = "";
    public static Seq<String> gpus = new Seq();
    public static boolean hasIntel;
    public static boolean hasNvidia;
    public static boolean hasAMD;

    public static void init() {
        if (OS.isWindows) {
            try {
                rawGpuString = OS.exec("wmic", "path", "win32_VideoController", "get", "name");
                gpus = Seq.with(rawGpuString.split("\n")).map(s -> s.trim()).removeAll(s -> s.isEmpty() || s.equalsIgnoreCase("name"));
                hasIntel = rawGpuString.toLowerCase(Locale.ROOT).contains("intel");
                hasNvidia = rawGpuString.toLowerCase(Locale.ROOT).contains("nvidia");
                hasAMD = rawGpuString.toLowerCase(Locale.ROOT).contains("amd") || rawGpuString.toLowerCase(Locale.ROOT).contains("radeon");
            }
            catch (Exception e) {
                Log.err(e);
            }
        }
    }
}

