/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.scene.Element;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.layout.Table;
import mindustry.Vars;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.net.Administration;
import mindustry.ui.dialogs.BaseDialog;

public class BansDialog
extends BaseDialog {
    public BansDialog() {
        super("@server.bans");
        this.addCloseButton();
        this.setup();
        this.shown(this::setup);
    }

    private void setup() {
        this.cont.clear();
        float w = 400.0f;
        float h = 80.0f;
        Table table = new Table();
        ScrollPane pane = new ScrollPane((Element)table);
        pane.setFadeScrollBars(false);
        if (Vars.netServer.admins.getBanned().size == 0) {
            table.add("@server.bans.none");
        }
        for (Administration.PlayerInfo info : Vars.netServer.admins.getBanned()) {
            Table res = new Table(Tex.button);
            res.margin(14.0f);
            res.labelWrap("IP: [lightgray]" + info.lastIP + "\n[]Name: [lightgray]" + info.lastName).width(w - h - 24.0f);
            res.add().growX();
            res.button(Icon.cancel, () -> Vars.ui.showConfirm("@confirm", "@confirmunban", () -> {
                Vars.netServer.admins.unbanPlayerID(info.id);
                this.setup();
            })).size(h).pad(-14.0f);
            table.add(res).width(w).height(h);
            table.row();
        }
        this.cont.add(pane);
    }
}

