/*
 * Decompiled with CFR 0.152.
 */
package arc.util;

import arc.math.geom.Vec2;

public enum Scaling {
    fit,
    bounded,
    fill,
    fillX,
    fillY,
    stretch,
    stretchX,
    stretchY,
    none;

    private static final Vec2 temp;

    public Vec2 apply(float sourceWidth, float sourceHeight, float targetWidth, float targetHeight) {
        switch (this) {
            case fit: {
                float targetRatio = targetHeight / targetWidth;
                float sourceRatio = sourceHeight / sourceWidth;
                float scale = targetRatio > sourceRatio ? targetWidth / sourceWidth : targetHeight / sourceHeight;
                Scaling.temp.x = sourceWidth * scale;
                Scaling.temp.y = sourceHeight * scale;
                break;
            }
            case fill: {
                float targetRatio = targetHeight / targetWidth;
                float sourceRatio = sourceHeight / sourceWidth;
                float scale = targetRatio < sourceRatio ? targetWidth / sourceWidth : targetHeight / sourceHeight;
                Scaling.temp.x = sourceWidth * scale;
                Scaling.temp.y = sourceHeight * scale;
                break;
            }
            case fillX: {
                float scale = targetWidth / sourceWidth;
                Scaling.temp.x = sourceWidth * scale;
                Scaling.temp.y = sourceHeight * scale;
                break;
            }
            case fillY: {
                float scale = targetHeight / sourceHeight;
                Scaling.temp.x = sourceWidth * scale;
                Scaling.temp.y = sourceHeight * scale;
                break;
            }
            case stretch: {
                Scaling.temp.x = targetWidth;
                Scaling.temp.y = targetHeight;
                break;
            }
            case stretchX: {
                Scaling.temp.x = targetWidth;
                Scaling.temp.y = sourceHeight;
                break;
            }
            case stretchY: {
                Scaling.temp.x = sourceWidth;
                Scaling.temp.y = targetHeight;
                break;
            }
            case bounded: {
                if (sourceHeight > targetHeight || sourceWidth > targetWidth) {
                    return fit.apply(sourceWidth, sourceHeight, targetWidth, targetHeight);
                }
                return none.apply(sourceWidth, sourceHeight, targetWidth, targetHeight);
            }
            case none: {
                Scaling.temp.x = sourceWidth;
                Scaling.temp.y = sourceHeight;
            }
        }
        return temp;
    }

    static {
        temp = new Vec2();
    }
}

