# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module SIGNALR
      # @!group Attribute Names
    
      # SignalR HTTP connection closure status.
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   app_shutdown
      #   timeout
      #
      SIGNALR_CONNECTION_STATUS = 'signalr.connection.status'
  
      # [SignalR transport type](https://github.com/dotnet/aspnetcore/blob/main/src/SignalR/docs/specs/TransportProtocols.md)
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   web_sockets
      #   long_polling
      #
      SIGNALR_TRANSPORT = 'signalr.transport'
  
      # @!endgroup
    end
  end
end