# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module SERVICE
      # @!group Attribute Names
    
      # Logical name of the service.
      #
      # MUST be the same for all instances of horizontally scaled services. If the value was not specified, SDKs MUST fallback to `unknown_service:` concatenated with [`process.executable.name`](process.md), e.g. `unknown_service:bash`. If `process.executable.name` is not available, the value MUST be set to `unknown_service`.
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   shoppingcart
      #
      SERVICE_NAME = 'service.name'
  
      # The version string of the service API or implementation. The format is not defined by these conventions.
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   2.0.0
      #   a01dbef8a
      #
      SERVICE_VERSION = 'service.version'
  
      # @!endgroup
    end
  end
end