# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module VCS
        # @!group Metrics Names
      
        # The number of changes (pull requests/merge requests/changelists) in a repository, categorized by their state (e.g. open or merged)
        #
        # @note Stability Level: development
        VCS_CHANGE_COUNT = 'vcs.change.count'
    
        # The time duration a change (pull request/merge request/changelist) has been in a given state.
        #
        # @note Stability Level: development
        VCS_CHANGE_DURATION = 'vcs.change.duration'
    
        # The amount of time since its creation it took a change (pull request/merge request/changelist) to get the first approval.
        #
        # @note Stability Level: development
        VCS_CHANGE_TIME_TO_APPROVAL = 'vcs.change.time_to_approval'
    
        # The amount of time since its creation it took a change (pull request/merge request/changelist) to get merged into the target(base) ref.
        #
        # @note Stability Level: development
        VCS_CHANGE_TIME_TO_MERGE = 'vcs.change.time_to_merge'
    
        # The number of unique contributors to a repository
        #
        # @note Stability Level: development
        VCS_CONTRIBUTOR_COUNT = 'vcs.contributor.count'
    
        # The number of refs of type branch or tag in a repository.
        #
        # @note Stability Level: development
        VCS_REF_COUNT = 'vcs.ref.count'
    
        # The number of lines added/removed in a ref (branch) relative to the ref from the `vcs.ref.base.name` attribute.
        #
        # This metric should be reported for each `vcs.line_change.type` value. For example if a ref added 3 lines and removed 2 lines,
        # instrumentation SHOULD report two measurements: 3 and 2 (both positive numbers).
        # If number of lines added/removed should be calculated from the start of time, then `vcs.ref.base.name` SHOULD be set to an empty string.
        #
        # @note Stability Level: development
        VCS_REF_LINES_DELTA = 'vcs.ref.lines_delta'
    
        # The number of revisions (commits) a ref (branch) is ahead/behind the branch from the `vcs.ref.base.name` attribute
        #
        # This metric should be reported for each `vcs.revision_delta.direction` value. For example if branch `a` is 3 commits behind and 2 commits ahead of `trunk`,
        # instrumentation SHOULD report two measurements: 3 and 2 (both positive numbers) and `vcs.ref.base.name` is set to `trunk`.
        #
        # @note Stability Level: development
        VCS_REF_REVISIONS_DELTA = 'vcs.ref.revisions_delta'
    
        # Time a ref (branch) created from the default branch (trunk) has existed. The `ref.type` attribute will always be `branch`
        #
        # @note Stability Level: development
        VCS_REF_TIME = 'vcs.ref.time'
    
        # The number of repositories in an organization.
        #
        # @note Stability Level: development
        VCS_REPOSITORY_COUNT = 'vcs.repository.count'
    
        # @!endgroup
      end
    end
  end
end