# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module VCS
        # @!group Attribute Names
      
        # The ID of the change (pull request/merge request/changelist) if applicable. This is usually a unique (within repository) identifier generated by the VCS system.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   123
        #
        VCS_CHANGE_ID = 'vcs.change.id'
    
        # The state of the change (pull request/merge request/changelist).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   open
        #   closed
        #   merged
        #
        VCS_CHANGE_STATE = 'vcs.change.state'
    
        # The human readable title of the change (pull request/merge request/changelist). This title is often a brief summary of the change and may get merged in to a ref as the commit summary.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Fixes broken thing
        #   feat: add my new feature
        #   [chore] update dependency
        #
        VCS_CHANGE_TITLE = 'vcs.change.title'
    
        # The type of line change being measured on a branch or change.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   added
        #   removed
        #
        VCS_LINE_CHANGE_TYPE = 'vcs.line_change.type'
    
        # The group owner within the version control system.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   my-org
        #   myteam
        #   business-unit
        #
        VCS_OWNER_NAME = 'vcs.owner.name'
    
        # The name of the version control system provider.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   github
        #   gitlab
        #   gitea
        #   bitbucket
        #
        VCS_PROVIDER_NAME = 'vcs.provider.name'
    
        # The name of the [reference](https://git-scm.com/docs/gitglossary#def_ref) such as **branch** or **tag** in the repository.
        #
        # `base` refers to the starting point of a change. For example, `main`
        # would be the base reference of type branch if you've created a new
        # reference of type branch from it and created new commits.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   my-feature-branch
        #   tag-1-test
        #
        VCS_REF_BASE_NAME = 'vcs.ref.base.name'
    
        # The revision, literally [revised version](https://www.merriam-webster.com/dictionary/revision), The revision most often refers to a commit object in Git, or a revision number in SVN.
        #
        # `base` refers to the starting point of a change. For example, `main`
        # would be the base reference of type branch if you've created a new
        # reference of type branch from it and created new commits. The
        # revision can be a full [hash value (see
        # glossary)](https://nvlpubs.nist.gov/nistpubs/FIPS/NIST.FIPS.186-5.pdf),
        # of the recorded change to a ref within a repository pointing to a
        # commit [commit](https://git-scm.com/docs/git-commit) object. It does
        # not necessarily have to be a hash; it can simply define a [revision
        # number](https://svnbook.red-bean.com/en/1.7/svn.tour.revs.specifiers.html)
        # which is an integer that is monotonically increasing. In cases where
        # it is identical to the `ref.base.name`, it SHOULD still be included.
        # It is up to the implementer to decide which value to set as the
        # revision based on the VCS system and situational context.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   9d59409acf479dfa0df1aa568182e43e43df8bbe28d60fcf2bc52e30068802cc
        #   main
        #   123
        #   HEAD
        #
        VCS_REF_BASE_REVISION = 'vcs.ref.base.revision'
    
        # The type of the [reference](https://git-scm.com/docs/gitglossary#def_ref) in the repository.
        #
        # `base` refers to the starting point of a change. For example, `main`
        # would be the base reference of type branch if you've created a new
        # reference of type branch from it and created new commits.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   branch
        #   tag
        #
        VCS_REF_BASE_TYPE = 'vcs.ref.base.type'
    
        # The name of the [reference](https://git-scm.com/docs/gitglossary#def_ref) such as **branch** or **tag** in the repository.
        #
        # `head` refers to where you are right now; the current reference at a
        # given time.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   my-feature-branch
        #   tag-1-test
        #
        VCS_REF_HEAD_NAME = 'vcs.ref.head.name'
    
        # The revision, literally [revised version](https://www.merriam-webster.com/dictionary/revision), The revision most often refers to a commit object in Git, or a revision number in SVN.
        #
        # `head` refers to where you are right now; the current reference at a
        # given time.The revision can be a full [hash value (see
        # glossary)](https://nvlpubs.nist.gov/nistpubs/FIPS/NIST.FIPS.186-5.pdf),
        # of the recorded change to a ref within a repository pointing to a
        # commit [commit](https://git-scm.com/docs/git-commit) object. It does
        # not necessarily have to be a hash; it can simply define a [revision
        # number](https://svnbook.red-bean.com/en/1.7/svn.tour.revs.specifiers.html)
        # which is an integer that is monotonically increasing. In cases where
        # it is identical to the `ref.head.name`, it SHOULD still be included.
        # It is up to the implementer to decide which value to set as the
        # revision based on the VCS system and situational context.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   9d59409acf479dfa0df1aa568182e43e43df8bbe28d60fcf2bc52e30068802cc
        #   main
        #   123
        #   HEAD
        #
        VCS_REF_HEAD_REVISION = 'vcs.ref.head.revision'
    
        # The type of the [reference](https://git-scm.com/docs/gitglossary#def_ref) in the repository.
        #
        # `head` refers to where you are right now; the current reference at a
        # given time.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   branch
        #   tag
        #
        VCS_REF_HEAD_TYPE = 'vcs.ref.head.type'
    
        # The type of the [reference](https://git-scm.com/docs/gitglossary#def_ref) in the repository.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   branch
        #   tag
        #
        VCS_REF_TYPE = 'vcs.ref.type'
    
        # Deprecated, use `vcs.change.id` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   123
        #
        # @deprecated {"note": "Replaced by `vcs.change.id`.", "reason": "renamed", "renamed_to": "vcs.change.id"}
        VCS_REPOSITORY_CHANGE_ID = 'vcs.repository.change.id'
    
        # Deprecated, use `vcs.change.title` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Fixes broken thing
        #   feat: add my new feature
        #   [chore] update dependency
        #
        # @deprecated {"note": "Replaced by `vcs.change.title`.", "reason": "renamed", "renamed_to": "vcs.change.title"}
        VCS_REPOSITORY_CHANGE_TITLE = 'vcs.repository.change.title'
    
        # The human readable name of the repository. It SHOULD NOT include any additional identifier like Group/SubGroup in GitLab or organization in GitHub.
        #
        # Due to it only being the name, it can clash with forks of the same
        # repository if collecting telemetry across multiple orgs or groups in
        # the same backends.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   semantic-conventions
        #   my-cool-repo
        #
        VCS_REPOSITORY_NAME = 'vcs.repository.name'
    
        # Deprecated, use `vcs.ref.head.name` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   my-feature-branch
        #   tag-1-test
        #
        # @deprecated {"note": "Replaced by `vcs.ref.head.name`.", "reason": "renamed", "renamed_to": "vcs.ref.head.name"}
        VCS_REPOSITORY_REF_NAME = 'vcs.repository.ref.name'
    
        # Deprecated, use `vcs.ref.head.revision` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   9d59409acf479dfa0df1aa568182e43e43df8bbe28d60fcf2bc52e30068802cc
        #   main
        #   123
        #   HEAD
        #
        # @deprecated {"note": "Replaced by `vcs.ref.head.revision`.", "reason": "renamed", "renamed_to": "vcs.ref.head.revision"}
        VCS_REPOSITORY_REF_REVISION = 'vcs.repository.ref.revision'
    
        # Deprecated, use `vcs.ref.head.type` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   branch
        #   tag
        #
        # @deprecated {"note": "Replaced by `vcs.ref.head.type`.", "reason": "renamed", "renamed_to": "vcs.ref.head.type"}
        VCS_REPOSITORY_REF_TYPE = 'vcs.repository.ref.type'
    
        # The [canonical URL](https://support.google.com/webmasters/answer/10347851?hl=en#:~:text=A%20canonical%20URL%20is%20the,Google%20chooses%20one%20as%20canonical.) of the repository providing the complete HTTP(S) address in order to locate and identify the repository through a browser.
        #
        # In Git Version Control Systems, the canonical URL SHOULD NOT include
        # the `.git` extension.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   https://github.com/opentelemetry/open-telemetry-collector-contrib
        #   https://gitlab.com/my-org/my-project/my-projects-project/repo
        #
        VCS_REPOSITORY_URL_FULL = 'vcs.repository.url.full'
    
        # The type of revision comparison.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ahead
        #   behind
        #
        VCS_REVISION_DELTA_DIRECTION = 'vcs.revision_delta.direction'
    
        # @!endgroup
      end
    end
  end
end