# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module V8JS
        # @!group Attribute Names
      
        # The type of garbage collection.
        #
        # @note Stability Level: development
        V8JS_GC_TYPE = 'v8js.gc.type'
    
        # The name of the space type of heap memory.
        #
        # Value can be retrieved from value `space_name` of [`v8.getHeapSpaceStatistics()`](https://nodejs.org/api/v8.html#v8getheapspacestatistics)
        #
        # @note Stability Level: development
        V8JS_HEAP_SPACE_NAME = 'v8js.heap.space.name'
    
        # @!endgroup
      end
    end
  end
end