# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module USER
        # @!group Attribute Names
      
        # User email address.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   a.einstein@example.com
        #
        USER_EMAIL = 'user.email'
    
        # User's full name
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Albert Einstein
        #
        USER_FULL_NAME = 'user.full_name'
    
        # Unique user hash to correlate information for a user in anonymized form.
        #
        # Useful if `user.id` or `user.name` contain confidential information and cannot be used.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   364fc68eaf4c8acec74a4e52d7d1feaa
        #
        USER_HASH = 'user.hash'
    
        # Unique identifier of the user.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   S-1-5-21-202424912787-2692429404-2351956786-1000
        #
        USER_ID = 'user.id'
    
        # Short name or login/username of the user.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   a.einstein
        #
        USER_NAME = 'user.name'
    
        # Array of user roles at the time of the event.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ["admin", "reporting_user"]
        #
        USER_ROLES = 'user.roles'
    
        # @!endgroup
      end
    end
  end
end