# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module URL
        # @!group Attribute Names
      
        # Domain extracted from the `url.full`, such as "opentelemetry.io".
        #
        # In some cases a URL may refer to an IP and/or port directly, without a domain name. In this case, the IP address would go to the domain field. If the URL contains a [literal IPv6 address](https://www.rfc-editor.org/rfc/rfc2732#section-2) enclosed by `[` and `]`, the `[` and `]` characters should also be captured in the domain field.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   www.foo.bar
        #   opentelemetry.io
        #   3.12.167.2
        #   [1080:0:0:0:8:800:200C:417A]
        #
        URL_DOMAIN = 'url.domain'
    
        # The file extension extracted from the `url.full`, excluding the leading dot.
        #
        # The file extension is only set if it exists, as not every url has a file extension. When the file name has multiple extensions `example.tar.gz`, only the last one should be captured `gz`, not `tar.gz`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   png
        #   gz
        #
        URL_EXTENSION = 'url.extension'
    
        # The [URI fragment](https://www.rfc-editor.org/rfc/rfc3986#section-3.5) component
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   SemConv
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::URL::URL_FRAGMENT}.
        URL_FRAGMENT = 'url.fragment'
    
        # Absolute URL describing a network resource according to [RFC3986](https://www.rfc-editor.org/rfc/rfc3986)
        #
        # For network calls, URL usually has `scheme://host[:port][path][?query][#fragment]` format, where the fragment
        # is not transmitted over HTTP, but if it is known, it SHOULD be included nevertheless.
        #
        # `url.full` MUST NOT contain credentials passed via URL in form of `https://username:password@www.example.com/`.
        # In such case username and password SHOULD be redacted and attribute's value SHOULD be `https://REDACTED:REDACTED@www.example.com/`.
        #
        # `url.full` SHOULD capture the absolute URL when it is available (or can be reconstructed).
        #
        # Sensitive content provided in `url.full` SHOULD be scrubbed when instrumentations can identify it.
        #
        #
        # Query string values for the following keys SHOULD be redacted by default and replaced by the
        # value `REDACTED`:
        #
        # - [`AWSAccessKeyId`](https://docs.aws.amazon.com/AmazonS3/latest/userguide/RESTAuthentication.html#RESTAuthenticationQueryStringAuth)
        # - [`Signature`](https://docs.aws.amazon.com/AmazonS3/latest/userguide/RESTAuthentication.html#RESTAuthenticationQueryStringAuth)
        # - [`sig`](https://learn.microsoft.com/azure/storage/common/storage-sas-overview#sas-token)
        # - [`X-Goog-Signature`](https://cloud.google.com/storage/docs/access-control/signed-urls)
        #
        # This list is subject to change over time.
        #
        # When a query string value is redacted, the query string key SHOULD still be preserved, e.g.
        # `https://www.example.com/path?color=blue&sig=REDACTED`.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   https://www.foo.bar/search?q=OpenTelemetry#SemConv
        #   //localhost
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::URL::URL_FULL}.
        URL_FULL = 'url.full'
    
        # Unmodified original URL as seen in the event source.
        #
        # In network monitoring, the observed URL may be a full URL, whereas in access logs, the URL is often just represented as a path. This field is meant to represent the URL as it was observed, complete or not.
        # `url.original` might contain credentials passed via URL in form of `https://username:password@www.example.com/`. In such case password and username SHOULD NOT be redacted and attribute's value SHOULD remain the same.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   https://www.foo.bar/search?q=OpenTelemetry#SemConv
        #   search?q=OpenTelemetry
        #
        URL_ORIGINAL = 'url.original'
    
        # The [URI path](https://www.rfc-editor.org/rfc/rfc3986#section-3.3) component
        #
        # Sensitive content provided in `url.path` SHOULD be scrubbed when instrumentations can identify it.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   /search
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::URL::URL_PATH}.
        URL_PATH = 'url.path'
    
        # Port extracted from the `url.full`
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   443
        #
        URL_PORT = 'url.port'
    
        # The [URI query](https://www.rfc-editor.org/rfc/rfc3986#section-3.4) component
        #
        # Sensitive content provided in `url.query` SHOULD be scrubbed when instrumentations can identify it.
        #
        #
        # Query string values for the following keys SHOULD be redacted by default and replaced by the value `REDACTED`:
        #
        # - [`AWSAccessKeyId`](https://docs.aws.amazon.com/AmazonS3/latest/userguide/RESTAuthentication.html#RESTAuthenticationQueryStringAuth)
        # - [`Signature`](https://docs.aws.amazon.com/AmazonS3/latest/userguide/RESTAuthentication.html#RESTAuthenticationQueryStringAuth)
        # - [`sig`](https://learn.microsoft.com/azure/storage/common/storage-sas-overview#sas-token)
        # - [`X-Goog-Signature`](https://cloud.google.com/storage/docs/access-control/signed-urls)
        #
        # This list is subject to change over time.
        #
        # When a query string value is redacted, the query string key SHOULD still be preserved, e.g.
        # `q=OpenTelemetry&sig=REDACTED`.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   q=OpenTelemetry
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::URL::URL_QUERY}.
        URL_QUERY = 'url.query'
    
        # The highest registered url domain, stripped of the subdomain.
        #
        # This value can be determined precisely with the [public suffix list](https://publicsuffix.org/). For example, the registered domain for `foo.example.com` is `example.com`. Trying to approximate this by simply taking the last two labels will not work well for TLDs such as `co.uk`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   example.com
        #   foo.co.uk
        #
        URL_REGISTERED_DOMAIN = 'url.registered_domain'
    
        # The [URI scheme](https://www.rfc-editor.org/rfc/rfc3986#section-3.1) component identifying the used protocol.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   https
        #   ftp
        #   telnet
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::URL::URL_SCHEME}.
        URL_SCHEME = 'url.scheme'
    
        # The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain. In a partially qualified domain, or if the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain.
        #
        # The subdomain portion of `www.east.mydomain.co.uk` is `east`. If the domain has multiple levels of subdomain, such as `sub2.sub1.example.com`, the subdomain field should contain `sub2.sub1`, with no trailing period.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   east
        #   sub2.sub1
        #
        URL_SUBDOMAIN = 'url.subdomain'
    
        # The low-cardinality template of an [absolute path reference](https://www.rfc-editor.org/rfc/rfc3986#section-4.2).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   /users/{id}
        #   /users/:id
        #   /users?id={id}
        #
        URL_TEMPLATE = 'url.template'
    
        # The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is `com`.
        #
        # This value can be determined precisely with the [public suffix list](https://publicsuffix.org/).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   com
        #   co.uk
        #
        URL_TOP_LEVEL_DOMAIN = 'url.top_level_domain'
    
        # @!endgroup
      end
    end
  end
end