# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module TLS
        # @!group Attribute Names
      
        # String indicating the [cipher](https://datatracker.ietf.org/doc/html/rfc5246#appendix-A.5) used during the current connection.
        #
        # The values allowed for `tls.cipher` MUST be one of the `Descriptions` of the [registered TLS Cipher Suits](https://www.iana.org/assignments/tls-parameters/tls-parameters.xhtml#table-tls-parameters-4).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   TLS_RSA_WITH_3DES_EDE_CBC_SHA
        #   TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256
        #
        TLS_CIPHER = 'tls.cipher'
    
        # PEM-encoded stand-alone certificate offered by the client. This is usually mutually-exclusive of `client.certificate_chain` since this value also exists in that list.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   MII...
        #
        TLS_CLIENT_CERTIFICATE = 'tls.client.certificate'
    
        # Array of PEM-encoded certificates that make up the certificate chain offered by the client. This is usually mutually-exclusive of `client.certificate` since that value should be the first certificate in the chain.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ["MII...", "MI..."]
        #
        TLS_CLIENT_CERTIFICATE_CHAIN = 'tls.client.certificate_chain'
    
        # Certificate fingerprint using the MD5 digest of DER-encoded version of certificate offered by the client. For consistency with other hash values, this value should be formatted as an uppercase hash.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   0F76C7F2C55BFD7D8E8B8F4BFBF0C9EC
        #
        TLS_CLIENT_HASH_MD5 = 'tls.client.hash.md5'
    
        # Certificate fingerprint using the SHA1 digest of DER-encoded version of certificate offered by the client. For consistency with other hash values, this value should be formatted as an uppercase hash.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   9E393D93138888D288266C2D915214D1D1CCEB2A
        #
        TLS_CLIENT_HASH_SHA1 = 'tls.client.hash.sha1'
    
        # Certificate fingerprint using the SHA256 digest of DER-encoded version of certificate offered by the client. For consistency with other hash values, this value should be formatted as an uppercase hash.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   0687F666A054EF17A08E2F2162EAB4CBC0D265E1D7875BE74BF3C712CA92DAF0
        #
        TLS_CLIENT_HASH_SHA256 = 'tls.client.hash.sha256'
    
        # Distinguished name of [subject](https://datatracker.ietf.org/doc/html/rfc5280#section-4.1.2.6) of the issuer of the x.509 certificate presented by the client.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   CN=Example Root CA, OU=Infrastructure Team, DC=example, DC=com
        #
        TLS_CLIENT_ISSUER = 'tls.client.issuer'
    
        # A hash that identifies clients based on how they perform an SSL/TLS handshake.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   d4e5b18d6b55c71272893221c96ba240
        #
        TLS_CLIENT_JA3 = 'tls.client.ja3'
    
        # Date/Time indicating when client certificate is no longer considered valid.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   2021-01-01T00:00:00.000Z
        #
        TLS_CLIENT_NOT_AFTER = 'tls.client.not_after'
    
        # Date/Time indicating when client certificate is first considered valid.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1970-01-01T00:00:00.000Z
        #
        TLS_CLIENT_NOT_BEFORE = 'tls.client.not_before'
    
        # Deprecated, use `server.address` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   opentelemetry.io
        #
        # @deprecated {"note": "Replaced by `server.address`.", "reason": "renamed", "renamed_to": "server.address"}
        TLS_CLIENT_SERVER_NAME = 'tls.client.server_name'
    
        # Distinguished name of subject of the x.509 certificate presented by the client.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   CN=myclient, OU=Documentation Team, DC=example, DC=com
        #
        TLS_CLIENT_SUBJECT = 'tls.client.subject'
    
        # Array of ciphers offered by the client during the client hello.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ["TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384"]
        #
        TLS_CLIENT_SUPPORTED_CIPHERS = 'tls.client.supported_ciphers'
    
        # String indicating the curve used for the given cipher, when applicable
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   secp256r1
        #
        TLS_CURVE = 'tls.curve'
    
        # Boolean flag indicating if the TLS negotiation was successful and transitioned to an encrypted tunnel.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   true
        #
        TLS_ESTABLISHED = 'tls.established'
    
        # String indicating the protocol being tunneled. Per the values in the [IANA registry](https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids), this string should be lower case.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   http/1.1
        #
        TLS_NEXT_PROTOCOL = 'tls.next_protocol'
    
        # Normalized lowercase protocol name parsed from original string of the negotiated [SSL/TLS protocol version](https://docs.openssl.org/1.1.1/man3/SSL_get_version/#return-values)
        #
        # @note Stability Level: development
        TLS_PROTOCOL_NAME = 'tls.protocol.name'
    
        # Numeric part of the version parsed from the original string of the negotiated [SSL/TLS protocol version](https://docs.openssl.org/1.1.1/man3/SSL_get_version/#return-values)
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1.2
        #   3
        #
        TLS_PROTOCOL_VERSION = 'tls.protocol.version'
    
        # Boolean flag indicating if this TLS connection was resumed from an existing TLS negotiation.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   true
        #
        TLS_RESUMED = 'tls.resumed'
    
        # PEM-encoded stand-alone certificate offered by the server. This is usually mutually-exclusive of `server.certificate_chain` since this value also exists in that list.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   MII...
        #
        TLS_SERVER_CERTIFICATE = 'tls.server.certificate'
    
        # Array of PEM-encoded certificates that make up the certificate chain offered by the server. This is usually mutually-exclusive of `server.certificate` since that value should be the first certificate in the chain.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ["MII...", "MI..."]
        #
        TLS_SERVER_CERTIFICATE_CHAIN = 'tls.server.certificate_chain'
    
        # Certificate fingerprint using the MD5 digest of DER-encoded version of certificate offered by the server. For consistency with other hash values, this value should be formatted as an uppercase hash.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   0F76C7F2C55BFD7D8E8B8F4BFBF0C9EC
        #
        TLS_SERVER_HASH_MD5 = 'tls.server.hash.md5'
    
        # Certificate fingerprint using the SHA1 digest of DER-encoded version of certificate offered by the server. For consistency with other hash values, this value should be formatted as an uppercase hash.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   9E393D93138888D288266C2D915214D1D1CCEB2A
        #
        TLS_SERVER_HASH_SHA1 = 'tls.server.hash.sha1'
    
        # Certificate fingerprint using the SHA256 digest of DER-encoded version of certificate offered by the server. For consistency with other hash values, this value should be formatted as an uppercase hash.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   0687F666A054EF17A08E2F2162EAB4CBC0D265E1D7875BE74BF3C712CA92DAF0
        #
        TLS_SERVER_HASH_SHA256 = 'tls.server.hash.sha256'
    
        # Distinguished name of [subject](https://datatracker.ietf.org/doc/html/rfc5280#section-4.1.2.6) of the issuer of the x.509 certificate presented by the client.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   CN=Example Root CA, OU=Infrastructure Team, DC=example, DC=com
        #
        TLS_SERVER_ISSUER = 'tls.server.issuer'
    
        # A hash that identifies servers based on how they perform an SSL/TLS handshake.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   d4e5b18d6b55c71272893221c96ba240
        #
        TLS_SERVER_JA3S = 'tls.server.ja3s'
    
        # Date/Time indicating when server certificate is no longer considered valid.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   2021-01-01T00:00:00.000Z
        #
        TLS_SERVER_NOT_AFTER = 'tls.server.not_after'
    
        # Date/Time indicating when server certificate is first considered valid.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1970-01-01T00:00:00.000Z
        #
        TLS_SERVER_NOT_BEFORE = 'tls.server.not_before'
    
        # Distinguished name of subject of the x.509 certificate presented by the server.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   CN=myserver, OU=Documentation Team, DC=example, DC=com
        #
        TLS_SERVER_SUBJECT = 'tls.server.subject'
    
        # @!endgroup
      end
    end
  end
end