# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module TEST
        # @!group Attribute Names
      
        # The fully qualified human readable name of the [test case](https://wikipedia.org/wiki/Test_case).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   org.example.TestCase1.test1
        #   example/tests/TestCase1.test1
        #   ExampleTestCase1_test1
        #
        TEST_CASE_NAME = 'test.case.name'
    
        # The status of the actual test case result from test execution.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   pass
        #   fail
        #
        TEST_CASE_RESULT_STATUS = 'test.case.result.status'
    
        # The human readable name of a [test suite](https://wikipedia.org/wiki/Test_suite).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   TestSuite1
        #
        TEST_SUITE_NAME = 'test.suite.name'
    
        # The status of the test suite run.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   success
        #   failure
        #   skipped
        #   aborted
        #   timed_out
        #   in_progress
        #
        TEST_SUITE_RUN_STATUS = 'test.suite.run.status'
    
        # @!endgroup
      end
    end
  end
end