# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module TELEMETRY
        # @!group Attribute Names
      
        # The name of the auto instrumentation agent or distribution, if used.
        #
        # Official auto instrumentation agents and distributions SHOULD set the `telemetry.distro.name` attribute to
        # a string starting with `opentelemetry-`, e.g. `opentelemetry-java-instrumentation`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   parts-unlimited-java
        #
        TELEMETRY_DISTRO_NAME = 'telemetry.distro.name'
    
        # The version string of the auto instrumentation agent or distribution, if used.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1.2.3
        #
        TELEMETRY_DISTRO_VERSION = 'telemetry.distro.version'
    
        # The language of the telemetry SDK.
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::TELEMETRY::TELEMETRY_SDK_LANGUAGE}.
        TELEMETRY_SDK_LANGUAGE = 'telemetry.sdk.language'
    
        # The name of the telemetry SDK as defined above.
        #
        # The OpenTelemetry SDK MUST set the `telemetry.sdk.name` attribute to `opentelemetry`.
        # If another SDK, like a fork or a vendor-provided implementation, is used, this SDK MUST set the
        # `telemetry.sdk.name` attribute to the fully-qualified class or module name of this SDK's main entry point
        # or another suitable identifier depending on the language.
        # The identifier `opentelemetry` is reserved and MUST NOT be used in this case.
        # All custom identifiers SHOULD be stable across different versions of an implementation.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   opentelemetry
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::TELEMETRY::TELEMETRY_SDK_NAME}.
        TELEMETRY_SDK_NAME = 'telemetry.sdk.name'
    
        # The version string of the telemetry SDK.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   1.2.3
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::TELEMETRY::TELEMETRY_SDK_VERSION}.
        TELEMETRY_SDK_VERSION = 'telemetry.sdk.version'
    
        # @!endgroup
      end
    end
  end
end