# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module SESSION
        # @!group Attribute Names
      
        # A unique id to identify a session.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   00112233-4455-6677-8899-aabbccddeeff
        #
        SESSION_ID = 'session.id'
    
        # The previous `session.id` for this user, when known.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   00112233-4455-6677-8899-aabbccddeeff
        #
        SESSION_PREVIOUS_ID = 'session.previous_id'
    
        # @!endgroup
      end
    end
  end
end