# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module OS
        # @!group Attribute Names
      
        # Unique identifier for a particular build or compilation of the operating system.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   TQ3C.230805.001.B2
        #   20E247
        #   22621
        #
        OS_BUILD_ID = 'os.build_id'
    
        # Human readable (not intended to be parsed) OS version information, like e.g. reported by `ver` or `lsb_release -a` commands.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Microsoft Windows [Version 10.0.18363.778]
        #   Ubuntu 18.04.1 LTS
        #
        OS_DESCRIPTION = 'os.description'
    
        # Human readable operating system name.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   iOS
        #   Android
        #   Ubuntu
        #
        OS_NAME = 'os.name'
    
        # The operating system type.
        #
        # @note Stability Level: development
        OS_TYPE = 'os.type'
    
        # The version string of the operating system as defined in [Version Attributes](/docs/resource/README.md#version-attributes).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   14.2.1
        #   18.04.1
        #
        OS_VERSION = 'os.version'
    
        # @!endgroup
      end
    end
  end
end