# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module NETWORK
        # @!group Attribute Names
      
        # The ISO 3166-1 alpha-2 2-character country code associated with the mobile carrier network.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   DE
        #
        NETWORK_CARRIER_ICC = 'network.carrier.icc'
    
        # The mobile carrier country code.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   310
        #
        NETWORK_CARRIER_MCC = 'network.carrier.mcc'
    
        # The mobile carrier network code.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   001
        #
        NETWORK_CARRIER_MNC = 'network.carrier.mnc'
    
        # The name of the mobile carrier.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   sprint
        #
        NETWORK_CARRIER_NAME = 'network.carrier.name'
    
        # The state of network connection
        #
        # Connection states are defined as part of the [rfc9293](https://datatracker.ietf.org/doc/html/rfc9293#section-3.3.2)
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   close_wait
        #
        NETWORK_CONNECTION_STATE = 'network.connection.state'
    
        # This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   LTE
        #
        NETWORK_CONNECTION_SUBTYPE = 'network.connection.subtype'
    
        # The internet connection type.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   wifi
        #
        NETWORK_CONNECTION_TYPE = 'network.connection.type'
    
        # The network interface name.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   lo
        #   eth0
        #
        NETWORK_INTERFACE_NAME = 'network.interface.name'
    
        # The network IO operation direction.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   transmit
        #
        NETWORK_IO_DIRECTION = 'network.io.direction'
    
        # Local address of the network connection - IP address or Unix domain socket name.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   10.1.2.80
        #   /tmp/my.sock
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::NETWORK::NETWORK_LOCAL_ADDRESS}.
        NETWORK_LOCAL_ADDRESS = 'network.local.address'
    
        # Local port number of the network connection.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   65123
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::NETWORK::NETWORK_LOCAL_PORT}.
        NETWORK_LOCAL_PORT = 'network.local.port'
    
        # Peer address of the network connection - IP address or Unix domain socket name.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   10.1.2.80
        #   /tmp/my.sock
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::NETWORK::NETWORK_PEER_ADDRESS}.
        NETWORK_PEER_ADDRESS = 'network.peer.address'
    
        # Peer port number of the network connection.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   65123
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::NETWORK::NETWORK_PEER_PORT}.
        NETWORK_PEER_PORT = 'network.peer.port'
    
        # [OSI application layer](https://wikipedia.org/wiki/Application_layer) or non-OSI equivalent.
        #
        # The value SHOULD be normalized to lowercase.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   amqp
        #   http
        #   mqtt
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::NETWORK::NETWORK_PROTOCOL_NAME}.
        NETWORK_PROTOCOL_NAME = 'network.protocol.name'
    
        # The actual version of the protocol used for network communication.
        #
        # If protocol version is subject to negotiation (for example using [ALPN](https://www.rfc-editor.org/rfc/rfc7301.html)), this attribute SHOULD be set to the negotiated version. If the actual protocol version is not known, this attribute SHOULD NOT be set.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   1.1
        #   2
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::NETWORK::NETWORK_PROTOCOL_VERSION}.
        NETWORK_PROTOCOL_VERSION = 'network.protocol.version'
    
        # [OSI transport layer](https://wikipedia.org/wiki/Transport_layer) or [inter-process communication method](https://wikipedia.org/wiki/Inter-process_communication).
        #
        # The value SHOULD be normalized to lowercase.
        #
        # Consider always setting the transport when setting a port number, since
        # a port number is ambiguous without knowing the transport. For example
        # different processes could be listening on TCP port 12345 and UDP port 12345.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   tcp
        #   udp
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::NETWORK::NETWORK_TRANSPORT}.
        NETWORK_TRANSPORT = 'network.transport'
    
        # [OSI network layer](https://wikipedia.org/wiki/Network_layer) or non-OSI equivalent.
        #
        # The value SHOULD be normalized to lowercase.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   ipv4
        #   ipv6
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::NETWORK::NETWORK_TYPE}.
        NETWORK_TYPE = 'network.type'
    
        # @!endgroup
      end
    end
  end
end