# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module KESTREL
        # @!group Metrics Names
      
        # Number of connections that are currently active on the server.
        #
        # Meter name: `Microsoft.AspNetCore.Server.Kestrel`; Added in: ASP.NET Core 8.0
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::KESTREL::KESTREL_ACTIVE_CONNECTIONS}.
        KESTREL_ACTIVE_CONNECTIONS = 'kestrel.active_connections'
    
        # Number of TLS handshakes that are currently in progress on the server.
        #
        # Meter name: `Microsoft.AspNetCore.Server.Kestrel`; Added in: ASP.NET Core 8.0
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::KESTREL::KESTREL_ACTIVE_TLS_HANDSHAKES}.
        KESTREL_ACTIVE_TLS_HANDSHAKES = 'kestrel.active_tls_handshakes'
    
        # The duration of connections on the server.
        #
        # Meter name: `Microsoft.AspNetCore.Server.Kestrel`; Added in: ASP.NET Core 8.0
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::KESTREL::KESTREL_CONNECTION_DURATION}.
        KESTREL_CONNECTION_DURATION = 'kestrel.connection.duration'
    
        # Number of connections that are currently queued and are waiting to start.
        #
        # Meter name: `Microsoft.AspNetCore.Server.Kestrel`; Added in: ASP.NET Core 8.0
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::KESTREL::KESTREL_QUEUED_CONNECTIONS}.
        KESTREL_QUEUED_CONNECTIONS = 'kestrel.queued_connections'
    
        # Number of HTTP requests on multiplexed connections (HTTP/2 and HTTP/3) that are currently queued and are waiting to start.
        #
        # Meter name: `Microsoft.AspNetCore.Server.Kestrel`; Added in: ASP.NET Core 8.0
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::KESTREL::KESTREL_QUEUED_REQUESTS}.
        KESTREL_QUEUED_REQUESTS = 'kestrel.queued_requests'
    
        # Number of connections rejected by the server.
        #
        # Connections are rejected when the currently active count exceeds the value configured with `MaxConcurrentConnections`.
        # Meter name: `Microsoft.AspNetCore.Server.Kestrel`; Added in: ASP.NET Core 8.0
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::KESTREL::KESTREL_REJECTED_CONNECTIONS}.
        KESTREL_REJECTED_CONNECTIONS = 'kestrel.rejected_connections'
    
        # The duration of TLS handshakes on the server.
        #
        # Meter name: `Microsoft.AspNetCore.Server.Kestrel`; Added in: ASP.NET Core 8.0
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::KESTREL::KESTREL_TLS_HANDSHAKE_DURATION}.
        KESTREL_TLS_HANDSHAKE_DURATION = 'kestrel.tls_handshake.duration'
    
        # Number of connections that are currently upgraded (WebSockets). .
        #
        # The counter only tracks HTTP/1.1 connections.
        #
        # Meter name: `Microsoft.AspNetCore.Server.Kestrel`; Added in: ASP.NET Core 8.0
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::KESTREL::KESTREL_UPGRADED_CONNECTIONS}.
        KESTREL_UPGRADED_CONNECTIONS = 'kestrel.upgraded_connections'
    
        # @!endgroup
      end
    end
  end
end