# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module K8S
        # @!group Metrics Names
      
        # Maximum CPU resource limit set for the container
        #
        # See https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#resourcerequirements-v1-core for details.
        #
        # @note Stability Level: development
        K8S_CONTAINER_CPU_LIMIT = 'k8s.container.cpu.limit'
    
        # CPU resource requested for the container
        #
        # See https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#resourcerequirements-v1-core for details.
        #
        # @note Stability Level: development
        K8S_CONTAINER_CPU_REQUEST = 'k8s.container.cpu.request'
    
        # Maximum ephemeral storage resource limit set for the container
        #
        # See https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#resourcerequirements-v1-core for details.
        #
        # @note Stability Level: development
        K8S_CONTAINER_EPHEMERAL_STORAGE_LIMIT = 'k8s.container.ephemeral_storage.limit'
    
        # Ephemeral storage resource requested for the container
        #
        # See https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#resourcerequirements-v1-core for details.
        #
        # @note Stability Level: development
        K8S_CONTAINER_EPHEMERAL_STORAGE_REQUEST = 'k8s.container.ephemeral_storage.request'
    
        # Maximum memory resource limit set for the container
        #
        # See https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#resourcerequirements-v1-core for details.
        #
        # @note Stability Level: development
        K8S_CONTAINER_MEMORY_LIMIT = 'k8s.container.memory.limit'
    
        # Memory resource requested for the container
        #
        # See https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#resourcerequirements-v1-core for details.
        #
        # @note Stability Level: development
        K8S_CONTAINER_MEMORY_REQUEST = 'k8s.container.memory.request'
    
        # Indicates whether the container is currently marked as ready to accept traffic, based on its readiness probe (1 = ready, 0 = not ready)
        #
        # This metric SHOULD reflect the value of the `ready` field in the
        # [K8s ContainerStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#containerstatus-v1-core).
        #
        # @note Stability Level: development
        K8S_CONTAINER_READY = 'k8s.container.ready'
    
        # Describes how many times the container has restarted (since the last counter reset)
        #
        # This value is pulled directly from the K8s API and the value can go indefinitely high and be reset to 0
        # at any time depending on how your kubelet is configured to prune dead containers.
        # It is best to not depend too much on the exact value but rather look at it as
        # either == 0, in which case you can conclude there were no restarts in the recent past, or > 0, in which case
        # you can conclude there were restarts in the recent past, and not try and analyze the value beyond that.
        #
        # @note Stability Level: development
        K8S_CONTAINER_RESTART_COUNT = 'k8s.container.restart.count'
    
        # Describes the number of K8s containers that are currently in a state for a given reason
        #
        # All possible container state reasons will be reported at each time interval to avoid missing metrics.
        # Only the value corresponding to the current state reason will be non-zero.
        #
        # @note Stability Level: development
        K8S_CONTAINER_STATUS_REASON = 'k8s.container.status.reason'
    
        # Describes the number of K8s containers that are currently in a given state
        #
        # All possible container states will be reported at each time interval to avoid missing metrics.
        # Only the value corresponding to the current state will be non-zero.
        #
        # @note Stability Level: development
        K8S_CONTAINER_STATUS_STATE = 'k8s.container.status.state'
    
        # Maximum storage resource limit set for the container
        #
        # See https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#resourcerequirements-v1-core for details.
        #
        # @note Stability Level: development
        K8S_CONTAINER_STORAGE_LIMIT = 'k8s.container.storage.limit'
    
        # Storage resource requested for the container
        #
        # See https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#resourcerequirements-v1-core for details.
        #
        # @note Stability Level: development
        K8S_CONTAINER_STORAGE_REQUEST = 'k8s.container.storage.request'
    
        # The number of actively running jobs for a cronjob
        #
        # This metric aligns with the `active` field of the
        # [K8s CronJobStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#cronjobstatus-v1-batch).
        #
        # @note Stability Level: development
        K8S_CRONJOB_ACTIVE_JOBS = 'k8s.cronjob.active_jobs'
    
        # Number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod
        #
        # This metric aligns with the `currentNumberScheduled` field of the
        # [K8s DaemonSetStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#daemonsetstatus-v1-apps).
        #
        # @note Stability Level: development
        K8S_DAEMONSET_CURRENT_SCHEDULED_NODES = 'k8s.daemonset.current_scheduled_nodes'
    
        # Number of nodes that should be running the daemon pod (including nodes currently running the daemon pod)
        #
        # This metric aligns with the `desiredNumberScheduled` field of the
        # [K8s DaemonSetStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#daemonsetstatus-v1-apps).
        #
        # @note Stability Level: development
        K8S_DAEMONSET_DESIRED_SCHEDULED_NODES = 'k8s.daemonset.desired_scheduled_nodes'
    
        # Number of nodes that are running the daemon pod, but are not supposed to run the daemon pod
        #
        # This metric aligns with the `numberMisscheduled` field of the
        # [K8s DaemonSetStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#daemonsetstatus-v1-apps).
        #
        # @note Stability Level: development
        K8S_DAEMONSET_MISSCHEDULED_NODES = 'k8s.daemonset.misscheduled_nodes'
    
        # Number of nodes that should be running the daemon pod and have one or more of the daemon pod running and ready
        #
        # This metric aligns with the `numberReady` field of the
        # [K8s DaemonSetStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#daemonsetstatus-v1-apps).
        #
        # @note Stability Level: development
        K8S_DAEMONSET_READY_NODES = 'k8s.daemonset.ready_nodes'
    
        # Total number of available replica pods (ready for at least minReadySeconds) targeted by this deployment
        #
        # This metric aligns with the `availableReplicas` field of the
        # [K8s DeploymentStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#deploymentstatus-v1-apps).
        #
        # @note Stability Level: development
        K8S_DEPLOYMENT_AVAILABLE_PODS = 'k8s.deployment.available_pods'
    
        # Number of desired replica pods in this deployment
        #
        # This metric aligns with the `replicas` field of the
        # [K8s DeploymentSpec](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#deploymentspec-v1-apps).
        #
        # @note Stability Level: development
        K8S_DEPLOYMENT_DESIRED_PODS = 'k8s.deployment.desired_pods'
    
        # Current number of replica pods managed by this horizontal pod autoscaler, as last seen by the autoscaler
        #
        # This metric aligns with the `currentReplicas` field of the
        # [K8s HorizontalPodAutoscalerStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#horizontalpodautoscalerstatus-v2-autoscaling)
        #
        # @note Stability Level: development
        K8S_HPA_CURRENT_PODS = 'k8s.hpa.current_pods'
    
        # Desired number of replica pods managed by this horizontal pod autoscaler, as last calculated by the autoscaler
        #
        # This metric aligns with the `desiredReplicas` field of the
        # [K8s HorizontalPodAutoscalerStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#horizontalpodautoscalerstatus-v2-autoscaling)
        #
        # @note Stability Level: development
        K8S_HPA_DESIRED_PODS = 'k8s.hpa.desired_pods'
    
        # The upper limit for the number of replica pods to which the autoscaler can scale up
        #
        # This metric aligns with the `maxReplicas` field of the
        # [K8s HorizontalPodAutoscalerSpec](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#horizontalpodautoscalerspec-v2-autoscaling)
        #
        # @note Stability Level: development
        K8S_HPA_MAX_PODS = 'k8s.hpa.max_pods'
    
        # Target average utilization, in percentage, for CPU resource in HPA config.
        #
        # This metric aligns with the `averageUtilization` field of the
        # [K8s HPA MetricTarget](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#metrictarget-v2-autoscaling).
        # If the type of the metric is [`ContainerResource`](https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/#support-for-metrics-apis),
        # the `k8s.container.name` attribute MUST be set to identify the specific container within the pod to which the metric applies.
        #
        # @note Stability Level: development
        K8S_HPA_METRIC_TARGET_CPU_AVERAGE_UTILIZATION = 'k8s.hpa.metric.target.cpu.average_utilization'
    
        # Target average value for CPU resource in HPA config.
        #
        # This metric aligns with the `averageValue` field of the
        # [K8s HPA MetricTarget](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#metrictarget-v2-autoscaling).
        # If the type of the metric is [`ContainerResource`](https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/#support-for-metrics-apis),
        # the `k8s.container.name` attribute MUST be set to identify the specific container within the pod to which the metric applies.
        #
        # @note Stability Level: development
        K8S_HPA_METRIC_TARGET_CPU_AVERAGE_VALUE = 'k8s.hpa.metric.target.cpu.average_value'
    
        # Target value for CPU resource in HPA config.
        #
        # This metric aligns with the `value` field of the
        # [K8s HPA MetricTarget](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#metrictarget-v2-autoscaling).
        # If the type of the metric is [`ContainerResource`](https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/#support-for-metrics-apis),
        # the `k8s.container.name` attribute MUST be set to identify the specific container within the pod to which the metric applies.
        #
        # @note Stability Level: development
        K8S_HPA_METRIC_TARGET_CPU_VALUE = 'k8s.hpa.metric.target.cpu.value'
    
        # The lower limit for the number of replica pods to which the autoscaler can scale down
        #
        # This metric aligns with the `minReplicas` field of the
        # [K8s HorizontalPodAutoscalerSpec](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#horizontalpodautoscalerspec-v2-autoscaling)
        #
        # @note Stability Level: development
        K8S_HPA_MIN_PODS = 'k8s.hpa.min_pods'
    
        # The number of pending and actively running pods for a job
        #
        # This metric aligns with the `active` field of the
        # [K8s JobStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#jobstatus-v1-batch).
        #
        # @note Stability Level: development
        K8S_JOB_ACTIVE_PODS = 'k8s.job.active_pods'
    
        # The desired number of successfully finished pods the job should be run with
        #
        # This metric aligns with the `completions` field of the
        # [K8s JobSpec](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#jobspec-v1-batch)..
        #
        # @note Stability Level: development
        K8S_JOB_DESIRED_SUCCESSFUL_PODS = 'k8s.job.desired_successful_pods'
    
        # The number of pods which reached phase Failed for a job
        #
        # This metric aligns with the `failed` field of the
        # [K8s JobStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#jobstatus-v1-batch).
        #
        # @note Stability Level: development
        K8S_JOB_FAILED_PODS = 'k8s.job.failed_pods'
    
        # The max desired number of pods the job should run at any given time
        #
        # This metric aligns with the `parallelism` field of the
        # [K8s JobSpec](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#jobspec-v1-batch).
        #
        # @note Stability Level: development
        K8S_JOB_MAX_PARALLEL_PODS = 'k8s.job.max_parallel_pods'
    
        # The number of pods which reached phase Succeeded for a job
        #
        # This metric aligns with the `succeeded` field of the
        # [K8s JobStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#jobstatus-v1-batch).
        #
        # @note Stability Level: development
        K8S_JOB_SUCCESSFUL_PODS = 'k8s.job.successful_pods'
    
        # Describes number of K8s namespaces that are currently in a given phase.
        #
        # @note Stability Level: development
        K8S_NAMESPACE_PHASE = 'k8s.namespace.phase'
    
        # Amount of cpu allocatable on the node
        #
        # @note Stability Level: development
        K8S_NODE_ALLOCATABLE_CPU = 'k8s.node.allocatable.cpu'
    
        # Amount of ephemeral-storage allocatable on the node
        #
        # @note Stability Level: development
        K8S_NODE_ALLOCATABLE_EPHEMERAL_STORAGE = 'k8s.node.allocatable.ephemeral_storage'
    
        # Amount of memory allocatable on the node
        #
        # @note Stability Level: development
        K8S_NODE_ALLOCATABLE_MEMORY = 'k8s.node.allocatable.memory'
    
        # Amount of pods allocatable on the node
        #
        # @note Stability Level: development
        K8S_NODE_ALLOCATABLE_PODS = 'k8s.node.allocatable.pods'
    
        # Describes the condition of a particular Node.
        #
        # All possible node condition pairs (type and status) will be reported at each time interval to avoid missing metrics. Condition pairs corresponding to the current conditions' statuses will be non-zero.
        #
        # @note Stability Level: development
        K8S_NODE_CONDITION_STATUS = 'k8s.node.condition.status'
    
        # Total CPU time consumed
        #
        # Total CPU time consumed by the specific Node on all available CPU cores
        #
        # @note Stability Level: development
        K8S_NODE_CPU_TIME = 'k8s.node.cpu.time'
    
        # Node's CPU usage, measured in cpus. Range from 0 to the number of allocatable CPUs
        #
        # CPU usage of the specific Node on all available CPU cores, averaged over the sample window
        #
        # @note Stability Level: development
        K8S_NODE_CPU_USAGE = 'k8s.node.cpu.usage'
    
        # Memory usage of the Node
        #
        # Total memory usage of the Node
        #
        # @note Stability Level: development
        K8S_NODE_MEMORY_USAGE = 'k8s.node.memory.usage'
    
        # Node network errors
        #
        # @note Stability Level: development
        K8S_NODE_NETWORK_ERRORS = 'k8s.node.network.errors'
    
        # Network bytes for the Node
        #
        # @note Stability Level: development
        K8S_NODE_NETWORK_IO = 'k8s.node.network.io'
    
        # The time the Node has been running
        #
        # Instrumentations SHOULD use a gauge with type `double` and measure uptime in seconds as a floating point number with the highest precision available.
        # The actual accuracy would depend on the instrumentation and operating system.
        #
        # @note Stability Level: development
        K8S_NODE_UPTIME = 'k8s.node.uptime'
    
        # Total CPU time consumed
        #
        # Total CPU time consumed by the specific Pod on all available CPU cores
        #
        # @note Stability Level: development
        K8S_POD_CPU_TIME = 'k8s.pod.cpu.time'
    
        # Pod's CPU usage, measured in cpus. Range from 0 to the number of allocatable CPUs
        #
        # CPU usage of the specific Pod on all available CPU cores, averaged over the sample window
        #
        # @note Stability Level: development
        K8S_POD_CPU_USAGE = 'k8s.pod.cpu.usage'
    
        # Memory usage of the Pod
        #
        # Total memory usage of the Pod
        #
        # @note Stability Level: development
        K8S_POD_MEMORY_USAGE = 'k8s.pod.memory.usage'
    
        # Pod network errors
        #
        # @note Stability Level: development
        K8S_POD_NETWORK_ERRORS = 'k8s.pod.network.errors'
    
        # Network bytes for the Pod
        #
        # @note Stability Level: development
        K8S_POD_NETWORK_IO = 'k8s.pod.network.io'
    
        # The time the Pod has been running
        #
        # Instrumentations SHOULD use a gauge with type `double` and measure uptime in seconds as a floating point number with the highest precision available.
        # The actual accuracy would depend on the instrumentation and operating system.
        #
        # @note Stability Level: development
        K8S_POD_UPTIME = 'k8s.pod.uptime'
    
        # Total number of available replica pods (ready for at least minReadySeconds) targeted by this replicaset
        #
        # This metric aligns with the `availableReplicas` field of the
        # [K8s ReplicaSetStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#replicasetstatus-v1-apps).
        #
        # @note Stability Level: development
        K8S_REPLICASET_AVAILABLE_PODS = 'k8s.replicaset.available_pods'
    
        # Number of desired replica pods in this replicaset
        #
        # This metric aligns with the `replicas` field of the
        # [K8s ReplicaSetSpec](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#replicasetspec-v1-apps).
        #
        # @note Stability Level: development
        K8S_REPLICASET_DESIRED_PODS = 'k8s.replicaset.desired_pods'
    
        # Deprecated, use `k8s.replicationcontroller.available_pods` instead.
        #
        # @note Stability Level: development
        # @deprecated {"note": "Replaced by `k8s.replicationcontroller.available_pods`.", "reason": "renamed", "renamed_to": "k8s.replicationcontroller.available_pods"}
        K8S_REPLICATION_CONTROLLER_AVAILABLE_PODS = 'k8s.replication_controller.available_pods'
    
        # Deprecated, use `k8s.replicationcontroller.desired_pods` instead.
        #
        # @note Stability Level: development
        # @deprecated {"note": "Replaced by `k8s.replicationcontroller.desired_pods`.", "reason": "renamed", "renamed_to": "k8s.replicationcontroller.desired_pods"}
        K8S_REPLICATION_CONTROLLER_DESIRED_PODS = 'k8s.replication_controller.desired_pods'
    
        # Total number of available replica pods (ready for at least minReadySeconds) targeted by this replication controller
        #
        # This metric aligns with the `availableReplicas` field of the
        # [K8s ReplicationControllerStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#replicationcontrollerstatus-v1-core)
        #
        # @note Stability Level: development
        K8S_REPLICATIONCONTROLLER_AVAILABLE_PODS = 'k8s.replicationcontroller.available_pods'
    
        # Number of desired replica pods in this replication controller
        #
        # This metric aligns with the `replicas` field of the
        # [K8s ReplicationControllerSpec](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#replicationcontrollerspec-v1-core)
        #
        # @note Stability Level: development
        K8S_REPLICATIONCONTROLLER_DESIRED_PODS = 'k8s.replicationcontroller.desired_pods'
    
        # The CPU limits in a specific namespace.
        # The value represents the configured quota limit of the resource in the namespace.
        #
        # This metric is retrieved from the `hard` field of the
        # [K8s ResourceQuotaStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.32/#resourcequotastatus-v1-core).
        #
        # @note Stability Level: development
        K8S_RESOURCEQUOTA_CPU_LIMIT_HARD = 'k8s.resourcequota.cpu.limit.hard'
    
        # The CPU limits in a specific namespace.
        # The value represents the current observed total usage of the resource in the namespace.
        #
        # This metric is retrieved from the `used` field of the
        # [K8s ResourceQuotaStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.32/#resourcequotastatus-v1-core).
        #
        # @note Stability Level: development
        K8S_RESOURCEQUOTA_CPU_LIMIT_USED = 'k8s.resourcequota.cpu.limit.used'
    
        # The CPU requests in a specific namespace.
        # The value represents the configured quota limit of the resource in the namespace.
        #
        # This metric is retrieved from the `hard` field of the
        # [K8s ResourceQuotaStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.32/#resourcequotastatus-v1-core).
        #
        # @note Stability Level: development
        K8S_RESOURCEQUOTA_CPU_REQUEST_HARD = 'k8s.resourcequota.cpu.request.hard'
    
        # The CPU requests in a specific namespace.
        # The value represents the current observed total usage of the resource in the namespace.
        #
        # This metric is retrieved from the `used` field of the
        # [K8s ResourceQuotaStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.32/#resourcequotastatus-v1-core).
        #
        # @note Stability Level: development
        K8S_RESOURCEQUOTA_CPU_REQUEST_USED = 'k8s.resourcequota.cpu.request.used'
    
        # The sum of local ephemeral storage limits in the namespace.
        # The value represents the configured quota limit of the resource in the namespace.
        #
        # This metric is retrieved from the `hard` field of the
        # [K8s ResourceQuotaStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.32/#resourcequotastatus-v1-core).
        #
        # @note Stability Level: development
        K8S_RESOURCEQUOTA_EPHEMERAL_STORAGE_LIMIT_HARD = 'k8s.resourcequota.ephemeral_storage.limit.hard'
    
        # The sum of local ephemeral storage limits in the namespace.
        # The value represents the current observed total usage of the resource in the namespace.
        #
        # This metric is retrieved from the `used` field of the
        # [K8s ResourceQuotaStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.32/#resourcequotastatus-v1-core).
        #
        # @note Stability Level: development
        K8S_RESOURCEQUOTA_EPHEMERAL_STORAGE_LIMIT_USED = 'k8s.resourcequota.ephemeral_storage.limit.used'
    
        # The sum of local ephemeral storage requests in the namespace.
        # The value represents the configured quota limit of the resource in the namespace.
        #
        # This metric is retrieved from the `hard` field of the
        # [K8s ResourceQuotaStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.32/#resourcequotastatus-v1-core).
        #
        # @note Stability Level: development
        K8S_RESOURCEQUOTA_EPHEMERAL_STORAGE_REQUEST_HARD = 'k8s.resourcequota.ephemeral_storage.request.hard'
    
        # The sum of local ephemeral storage requests in the namespace.
        # The value represents the current observed total usage of the resource in the namespace.
        #
        # This metric is retrieved from the `used` field of the
        # [K8s ResourceQuotaStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.32/#resourcequotastatus-v1-core).
        #
        # @note Stability Level: development
        K8S_RESOURCEQUOTA_EPHEMERAL_STORAGE_REQUEST_USED = 'k8s.resourcequota.ephemeral_storage.request.used'
    
        # The huge page requests in a specific namespace.
        # The value represents the configured quota limit of the resource in the namespace.
        #
        # This metric is retrieved from the `hard` field of the
        # [K8s ResourceQuotaStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.32/#resourcequotastatus-v1-core).
        #
        # @note Stability Level: development
        K8S_RESOURCEQUOTA_HUGEPAGE_COUNT_REQUEST_HARD = 'k8s.resourcequota.hugepage_count.request.hard'
    
        # The huge page requests in a specific namespace.
        # The value represents the current observed total usage of the resource in the namespace.
        #
        # This metric is retrieved from the `used` field of the
        # [K8s ResourceQuotaStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.32/#resourcequotastatus-v1-core).
        #
        # @note Stability Level: development
        K8S_RESOURCEQUOTA_HUGEPAGE_COUNT_REQUEST_USED = 'k8s.resourcequota.hugepage_count.request.used'
    
        # The memory limits in a specific namespace.
        # The value represents the configured quota limit of the resource in the namespace.
        #
        # This metric is retrieved from the `hard` field of the
        # [K8s ResourceQuotaStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.32/#resourcequotastatus-v1-core).
        #
        # @note Stability Level: development
        K8S_RESOURCEQUOTA_MEMORY_LIMIT_HARD = 'k8s.resourcequota.memory.limit.hard'
    
        # The memory limits in a specific namespace.
        # The value represents the current observed total usage of the resource in the namespace.
        #
        # This metric is retrieved from the `used` field of the
        # [K8s ResourceQuotaStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.32/#resourcequotastatus-v1-core).
        #
        # @note Stability Level: development
        K8S_RESOURCEQUOTA_MEMORY_LIMIT_USED = 'k8s.resourcequota.memory.limit.used'
    
        # The memory requests in a specific namespace.
        # The value represents the configured quota limit of the resource in the namespace.
        #
        # This metric is retrieved from the `hard` field of the
        # [K8s ResourceQuotaStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.32/#resourcequotastatus-v1-core).
        #
        # @note Stability Level: development
        K8S_RESOURCEQUOTA_MEMORY_REQUEST_HARD = 'k8s.resourcequota.memory.request.hard'
    
        # The memory requests in a specific namespace.
        # The value represents the current observed total usage of the resource in the namespace.
        #
        # This metric is retrieved from the `used` field of the
        # [K8s ResourceQuotaStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.32/#resourcequotastatus-v1-core).
        #
        # @note Stability Level: development
        K8S_RESOURCEQUOTA_MEMORY_REQUEST_USED = 'k8s.resourcequota.memory.request.used'
    
        # The object count limits in a specific namespace.
        # The value represents the configured quota limit of the resource in the namespace.
        #
        # This metric is retrieved from the `hard` field of the
        # [K8s ResourceQuotaStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.32/#resourcequotastatus-v1-core).
        #
        # @note Stability Level: development
        K8S_RESOURCEQUOTA_OBJECT_COUNT_HARD = 'k8s.resourcequota.object_count.hard'
    
        # The object count limits in a specific namespace.
        # The value represents the current observed total usage of the resource in the namespace.
        #
        # This metric is retrieved from the `used` field of the
        # [K8s ResourceQuotaStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.32/#resourcequotastatus-v1-core).
        #
        # @note Stability Level: development
        K8S_RESOURCEQUOTA_OBJECT_COUNT_USED = 'k8s.resourcequota.object_count.used'
    
        # The total number of PersistentVolumeClaims that can exist in the namespace.
        # The value represents the configured quota limit of the resource in the namespace.
        #
        # This metric is retrieved from the `hard` field of the
        # [K8s ResourceQuotaStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.32/#resourcequotastatus-v1-core).
        #
        # The `k8s.storageclass.name` should be required when a resource quota is defined for a specific
        # storage class.
        #
        # @note Stability Level: development
        K8S_RESOURCEQUOTA_PERSISTENTVOLUMECLAIM_COUNT_HARD = 'k8s.resourcequota.persistentvolumeclaim_count.hard'
    
        # The total number of PersistentVolumeClaims that can exist in the namespace.
        # The value represents the current observed total usage of the resource in the namespace.
        #
        # This metric is retrieved from the `used` field of the
        # [K8s ResourceQuotaStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.32/#resourcequotastatus-v1-core).
        #
        # The `k8s.storageclass.name` should be required when a resource quota is defined for a specific
        # storage class.
        #
        # @note Stability Level: development
        K8S_RESOURCEQUOTA_PERSISTENTVOLUMECLAIM_COUNT_USED = 'k8s.resourcequota.persistentvolumeclaim_count.used'
    
        # The storage requests in a specific namespace.
        # The value represents the configured quota limit of the resource in the namespace.
        #
        # This metric is retrieved from the `hard` field of the
        # [K8s ResourceQuotaStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.32/#resourcequotastatus-v1-core).
        #
        # The `k8s.storageclass.name` should be required when a resource quota is defined for a specific
        # storage class.
        #
        # @note Stability Level: development
        K8S_RESOURCEQUOTA_STORAGE_REQUEST_HARD = 'k8s.resourcequota.storage.request.hard'
    
        # The storage requests in a specific namespace.
        # The value represents the current observed total usage of the resource in the namespace.
        #
        # This metric is retrieved from the `used` field of the
        # [K8s ResourceQuotaStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.32/#resourcequotastatus-v1-core).
        #
        # The `k8s.storageclass.name` should be required when a resource quota is defined for a specific
        # storage class.
        #
        # @note Stability Level: development
        K8S_RESOURCEQUOTA_STORAGE_REQUEST_USED = 'k8s.resourcequota.storage.request.used'
    
        # The number of replica pods created by the statefulset controller from the statefulset version indicated by currentRevision
        #
        # This metric aligns with the `currentReplicas` field of the
        # [K8s StatefulSetStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#statefulsetstatus-v1-apps).
        #
        # @note Stability Level: development
        K8S_STATEFULSET_CURRENT_PODS = 'k8s.statefulset.current_pods'
    
        # Number of desired replica pods in this statefulset
        #
        # This metric aligns with the `replicas` field of the
        # [K8s StatefulSetSpec](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#statefulsetspec-v1-apps).
        #
        # @note Stability Level: development
        K8S_STATEFULSET_DESIRED_PODS = 'k8s.statefulset.desired_pods'
    
        # The number of replica pods created for this statefulset with a Ready Condition
        #
        # This metric aligns with the `readyReplicas` field of the
        # [K8s StatefulSetStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#statefulsetstatus-v1-apps).
        #
        # @note Stability Level: development
        K8S_STATEFULSET_READY_PODS = 'k8s.statefulset.ready_pods'
    
        # Number of replica pods created by the statefulset controller from the statefulset version indicated by updateRevision
        #
        # This metric aligns with the `updatedReplicas` field of the
        # [K8s StatefulSetStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.30/#statefulsetstatus-v1-apps).
        #
        # @note Stability Level: development
        K8S_STATEFULSET_UPDATED_PODS = 'k8s.statefulset.updated_pods'
    
        # @!endgroup
      end
    end
  end
end