# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module JVM
        # @!group Metrics Names
      
        # Number of buffers in the pool.
        #
        # @note Stability Level: development
        JVM_BUFFER_COUNT = 'jvm.buffer.count'
    
        # Measure of total memory capacity of buffers.
        #
        # @note Stability Level: development
        JVM_BUFFER_MEMORY_LIMIT = 'jvm.buffer.memory.limit'
    
        # Deprecated, use `jvm.buffer.memory.used` instead.
        #
        # @note Stability Level: development
        # @deprecated {"note": "Replaced by `jvm.buffer.memory.used`.", "reason": "renamed", "renamed_to": "jvm.buffer.memory.used"}
        JVM_BUFFER_MEMORY_USAGE = 'jvm.buffer.memory.usage'
    
        # Measure of memory used by buffers.
        #
        # @note Stability Level: development
        JVM_BUFFER_MEMORY_USED = 'jvm.buffer.memory.used'
    
        # Number of classes currently loaded.
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::JVM::JVM_CLASS_COUNT}.
        JVM_CLASS_COUNT = 'jvm.class.count'
    
        # Number of classes loaded since JVM start.
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::JVM::JVM_CLASS_LOADED}.
        JVM_CLASS_LOADED = 'jvm.class.loaded'
    
        # Number of classes unloaded since JVM start.
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::JVM::JVM_CLASS_UNLOADED}.
        JVM_CLASS_UNLOADED = 'jvm.class.unloaded'
    
        # Number of processors available to the Java virtual machine.
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::JVM::JVM_CPU_COUNT}.
        JVM_CPU_COUNT = 'jvm.cpu.count'
    
        # Recent CPU utilization for the process as reported by the JVM.
        #
        # The value range is [0.0,1.0]. This utilization is not defined as being for the specific interval since last measurement (unlike `system.cpu.utilization`). [Reference](https://docs.oracle.com/en/java/javase/17/docs/api/jdk.management/com/sun/management/OperatingSystemMXBean.html#getProcessCpuLoad()).
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::JVM::JVM_CPU_RECENT_UTILIZATION}.
        JVM_CPU_RECENT_UTILIZATION = 'jvm.cpu.recent_utilization'
    
        # CPU time used by the process as reported by the JVM.
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::JVM::JVM_CPU_TIME}.
        JVM_CPU_TIME = 'jvm.cpu.time'
    
        # Number of open file descriptors as reported by the JVM.
        #
        # @note Stability Level: development
        JVM_FILE_DESCRIPTOR_COUNT = 'jvm.file_descriptor.count'
    
        # Duration of JVM garbage collection actions.
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::JVM::JVM_GC_DURATION}.
        JVM_GC_DURATION = 'jvm.gc.duration'
    
        # Measure of memory committed.
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::JVM::JVM_MEMORY_COMMITTED}.
        JVM_MEMORY_COMMITTED = 'jvm.memory.committed'
    
        # Measure of initial memory requested.
        #
        # @note Stability Level: development
        JVM_MEMORY_INIT = 'jvm.memory.init'
    
        # Measure of max obtainable memory.
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::JVM::JVM_MEMORY_LIMIT}.
        JVM_MEMORY_LIMIT = 'jvm.memory.limit'
    
        # Measure of memory used.
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::JVM::JVM_MEMORY_USED}.
        JVM_MEMORY_USED = 'jvm.memory.used'
    
        # Measure of memory used, as measured after the most recent garbage collection event on this pool.
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::JVM::JVM_MEMORY_USED_AFTER_LAST_GC}.
        JVM_MEMORY_USED_AFTER_LAST_GC = 'jvm.memory.used_after_last_gc'
    
        # Average CPU load of the whole system for the last minute as reported by the JVM.
        #
        # The value range is [0,n], where n is the number of CPU cores - or a negative number if the value is not available. This utilization is not defined as being for the specific interval since last measurement (unlike `system.cpu.utilization`). [Reference](https://docs.oracle.com/en/java/javase/17/docs/api/java.management/java/lang/management/OperatingSystemMXBean.html#getSystemLoadAverage()).
        #
        # @note Stability Level: development
        JVM_SYSTEM_CPU_LOAD_1M = 'jvm.system.cpu.load_1m'
    
        # Recent CPU utilization for the whole system as reported by the JVM.
        #
        # The value range is [0.0,1.0]. This utilization is not defined as being for the specific interval since last measurement (unlike `system.cpu.utilization`). [Reference](https://docs.oracle.com/en/java/javase/17/docs/api/jdk.management/com/sun/management/OperatingSystemMXBean.html#getCpuLoad()).
        #
        # @note Stability Level: development
        JVM_SYSTEM_CPU_UTILIZATION = 'jvm.system.cpu.utilization'
    
        # Number of executing platform threads.
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::JVM::JVM_THREAD_COUNT}.
        JVM_THREAD_COUNT = 'jvm.thread.count'
    
        # @!endgroup
      end
    end
  end
end