# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module HW
        # @!group Metrics Names
      
        # Energy consumed by the component
        #
        # @note Stability Level: development
        HW_ENERGY = 'hw.energy'
    
        # Number of errors encountered by the component
        #
        # @note Stability Level: development
        HW_ERRORS = 'hw.errors'
    
        # Ambient (external) temperature of the physical host
        #
        # @note Stability Level: development
        HW_HOST_AMBIENT_TEMPERATURE = 'hw.host.ambient_temperature'
    
        # Total energy consumed by the entire physical host, in joules
        #
        # The overall energy usage of a host MUST be reported using the specific `hw.host.energy` and `hw.host.power` metrics **only**, instead of the generic `hw.energy` and `hw.power` described in the previous section, to prevent summing up overlapping values.
        #
        # @note Stability Level: development
        HW_HOST_ENERGY = 'hw.host.energy'
    
        # By how many degrees Celsius the temperature of the physical host can be increased, before reaching a warning threshold on one of the internal sensors
        #
        # @note Stability Level: development
        HW_HOST_HEATING_MARGIN = 'hw.host.heating_margin'
    
        # Instantaneous power consumed by the entire physical host in Watts (`hw.host.energy` is preferred)
        #
        # The overall energy usage of a host MUST be reported using the specific `hw.host.energy` and `hw.host.power` metrics **only**, instead of the generic `hw.energy` and `hw.power` described in the previous section, to prevent summing up overlapping values.
        #
        # @note Stability Level: development
        HW_HOST_POWER = 'hw.host.power'
    
        # Instantaneous power consumed by the component
        #
        # It is recommended to report `hw.energy` instead of `hw.power` when possible.
        #
        # @note Stability Level: development
        HW_POWER = 'hw.power'
    
        # Operational status: `1` (true) or `0` (false) for each of the possible states
        #
        # `hw.status` is currently specified as an *UpDownCounter* but would ideally be represented using a [*StateSet* as defined in OpenMetrics](https://github.com/prometheus/OpenMetrics/blob/v1.0.0/specification/OpenMetrics.md#stateset). This semantic convention will be updated once *StateSet* is specified in OpenTelemetry. This planned change is not expected to have any consequence on the way users query their timeseries backend to retrieve the values of `hw.status` over time.
        #
        # @note Stability Level: development
        HW_STATUS = 'hw.status'
    
        # @!endgroup
      end
    end
  end
end