# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module FILE
        # @!group Attribute Names
      
        # Time when the file was last accessed, in ISO 8601 format.
        #
        # This attribute might not be supported by some file systems — NFS, FAT32, in embedded OS, etc.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   2021-01-01T12:00:00Z
        #
        FILE_ACCESSED = 'file.accessed'
    
        # Array of file attributes.
        #
        # Attributes names depend on the OS or file system. Here’s a non-exhaustive list of values expected for this attribute: `archive`, `compressed`, `directory`, `encrypted`, `execute`, `hidden`, `immutable`, `journaled`, `read`, `readonly`, `symbolic link`, `system`, `temporary`, `write`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ["readonly", "hidden"]
        #
        FILE_ATTRIBUTES = 'file.attributes'
    
        # Time when the file attributes or metadata was last changed, in ISO 8601 format.
        #
        # `file.changed` captures the time when any of the file's properties or attributes (including the content) are changed, while `file.modified` captures the timestamp when the file content is modified.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   2021-01-01T12:00:00Z
        #
        FILE_CHANGED = 'file.changed'
    
        # Time when the file was created, in ISO 8601 format.
        #
        # This attribute might not be supported by some file systems — NFS, FAT32, in embedded OS, etc.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   2021-01-01T12:00:00Z
        #
        FILE_CREATED = 'file.created'
    
        # Directory where the file is located. It should include the drive letter, when appropriate.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   /home/user
        #   C:\Program Files\MyApp
        #
        FILE_DIRECTORY = 'file.directory'
    
        # File extension, excluding the leading dot.
        #
        # When the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz").
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   png
        #   gz
        #
        FILE_EXTENSION = 'file.extension'
    
        # Name of the fork. A fork is additional data associated with a filesystem object.
        #
        # On Linux, a resource fork is used to store additional data with a filesystem object. A file always has at least one fork for the data portion, and additional forks may exist.
        # On NTFS, this is analogous to an Alternate Data Stream (ADS), and the default data stream for a file is just called $DATA. Zone.Identifier is commonly used by Windows to track contents downloaded from the Internet. An ADS is typically of the form: C:\path\to\filename.extension:some_fork_name, and some_fork_name is the value that should populate `fork_name`. `filename.extension` should populate `file.name`, and `extension` should populate `file.extension`. The full path, `file.path`, will include the fork name.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Zone.Identifer
        #
        FILE_FORK_NAME = 'file.fork_name'
    
        # Primary Group ID (GID) of the file.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1000
        #
        FILE_GROUP_ID = 'file.group.id'
    
        # Primary group name of the file.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   users
        #
        FILE_GROUP_NAME = 'file.group.name'
    
        # Inode representing the file in the filesystem.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   256383
        #
        FILE_INODE = 'file.inode'
    
        # Mode of the file in octal representation.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   0640
        #
        FILE_MODE = 'file.mode'
    
        # Time when the file content was last modified, in ISO 8601 format.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   2021-01-01T12:00:00Z
        #
        FILE_MODIFIED = 'file.modified'
    
        # Name of the file including the extension, without the directory.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   example.png
        #
        FILE_NAME = 'file.name'
    
        # The user ID (UID) or security identifier (SID) of the file owner.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1000
        #
        FILE_OWNER_ID = 'file.owner.id'
    
        # Username of the file owner.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   root
        #
        FILE_OWNER_NAME = 'file.owner.name'
    
        # Full path to the file, including the file name. It should include the drive letter, when appropriate.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   /home/alice/example.png
        #   C:\Program Files\MyApp\myapp.exe
        #
        FILE_PATH = 'file.path'
    
        # File size in bytes.
        #
        # @note Stability Level: development
        FILE_SIZE = 'file.size'
    
        # Path to the target of a symbolic link.
        #
        # This attribute is only applicable to symbolic links.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   /usr/bin/python3
        #
        FILE_SYMBOLIC_LINK_TARGET_PATH = 'file.symbolic_link.target_path'
    
        # @!endgroup
      end
    end
  end
end