# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module FEATURE_FLAG
        # @!group Attribute Names
      
        # The unique identifier for the flag evaluation context. For example, the targeting key.
        #
        # @note Stability Level: release_candidate
        #
        # @example Sample Values
        #   5157782b-2203-4c80-a857-dbbd5e7761db
        #
        FEATURE_FLAG_CONTEXT_ID = 'feature_flag.context.id'
    
        # Deprecated, use `error.message` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Flag `header-color` expected type `string` but found type `number`
        #
        # @deprecated {"note": "Replaced by `error.message`.", "reason": "renamed", "renamed_to": "error.message"}
        FEATURE_FLAG_EVALUATION_ERROR_MESSAGE = 'feature_flag.evaluation.error.message'
    
        # Deprecated, use `feature_flag.result.reason` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   static
        #   targeting_match
        #   error
        #   default
        #
        # @deprecated {"note": "Replaced by `feature_flag.result.reason`.", "reason": "renamed", "renamed_to": "feature_flag.result.reason"}
        FEATURE_FLAG_EVALUATION_REASON = 'feature_flag.evaluation.reason'
    
        # The lookup key of the feature flag.
        #
        # @note Stability Level: release_candidate
        #
        # @example Sample Values
        #   logo-color
        #
        FEATURE_FLAG_KEY = 'feature_flag.key'
    
        # Identifies the feature flag provider.
        #
        # @note Stability Level: release_candidate
        #
        # @example Sample Values
        #   Flag Manager
        #
        FEATURE_FLAG_PROVIDER_NAME = 'feature_flag.provider.name'
    
        # The reason code which shows how a feature flag value was determined.
        #
        # @note Stability Level: release_candidate
        #
        # @example Sample Values
        #   static
        #   targeting_match
        #   error
        #   default
        #
        FEATURE_FLAG_RESULT_REASON = 'feature_flag.result.reason'
    
        # The evaluated value of the feature flag.
        #
        # With some feature flag providers, feature flag results can be quite large or contain private or sensitive details.
        # Because of this, `feature_flag.result.variant` is often the preferred attribute if it is available.
        #
        # It may be desirable to redact or otherwise limit the size and scope of `feature_flag.result.value` if possible.
        # Because the evaluated flag value is unstructured and may be any type, it is left to the instrumentation author to determine how best to achieve this.
        #
        # @note Stability Level: release_candidate
        #
        # @example Sample Values
        #   #ff0000
        #   true
        #   3
        #
        FEATURE_FLAG_RESULT_VALUE = 'feature_flag.result.value'
    
        # A semantic identifier for an evaluated flag value.
        #
        # A semantic identifier, commonly referred to as a variant, provides a means
        # for referring to a value without including the value itself. This can
        # provide additional context for understanding the meaning behind a value.
        # For example, the variant `red` maybe be used for the value `#c05543`.
        #
        # @note Stability Level: release_candidate
        #
        # @example Sample Values
        #   red
        #   true
        #   on
        #
        FEATURE_FLAG_RESULT_VARIANT = 'feature_flag.result.variant'
    
        # The identifier of the [flag set](https://openfeature.dev/specification/glossary/#flag-set) to which the feature flag belongs.
        #
        # @note Stability Level: release_candidate
        #
        # @example Sample Values
        #   proj-1
        #   ab98sgs
        #   service1/dev
        #
        FEATURE_FLAG_SET_ID = 'feature_flag.set.id'
    
        # Deprecated, use `feature_flag.result.variant` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   red
        #   true
        #   on
        #
        # @deprecated {"note": "Replaced by `feature_flag.result.variant`.", "reason": "renamed", "renamed_to": "feature_flag.result.variant"}
        FEATURE_FLAG_VARIANT = 'feature_flag.variant'
    
        # The version of the ruleset used during the evaluation. This may be any stable value which uniquely identifies the ruleset.
        #
        # @note Stability Level: release_candidate
        #
        # @example Sample Values
        #   1
        #   01ABCDEF
        #
        FEATURE_FLAG_VERSION = 'feature_flag.version'
    
        # @!endgroup
      end
    end
  end
end