# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module FAAS
        # @!group Metrics Names
      
        # Number of invocation cold starts
        #
        # @note Stability Level: development
        FAAS_COLDSTARTS = 'faas.coldstarts'
    
        # Distribution of CPU usage per invocation
        #
        # @note Stability Level: development
        FAAS_CPU_USAGE = 'faas.cpu_usage'
    
        # Number of invocation errors
        #
        # @note Stability Level: development
        FAAS_ERRORS = 'faas.errors'
    
        # Measures the duration of the function's initialization, such as a cold start
        #
        # @note Stability Level: development
        FAAS_INIT_DURATION = 'faas.init_duration'
    
        # Number of successful invocations
        #
        # @note Stability Level: development
        FAAS_INVOCATIONS = 'faas.invocations'
    
        # Measures the duration of the function's logic execution
        #
        # @note Stability Level: development
        FAAS_INVOKE_DURATION = 'faas.invoke_duration'
    
        # Distribution of max memory usage per invocation
        #
        # @note Stability Level: development
        FAAS_MEM_USAGE = 'faas.mem_usage'
    
        # Distribution of net I/O usage per invocation
        #
        # @note Stability Level: development
        FAAS_NET_IO = 'faas.net_io'
    
        # Number of invocation timeouts
        #
        # @note Stability Level: development
        FAAS_TIMEOUTS = 'faas.timeouts'
    
        # @!endgroup
      end
    end
  end
end