# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module EXCEPTION
        # @!group Attribute Names
      
        # Indicates that the exception is escaping the scope of the span.
        #
        # @note Stability Level: stable
        # @deprecated {"note": "It's no longer recommended to record exceptions that are handled and do not escape the scope of a span.\n", "reason": "obsoleted"}
        EXCEPTION_ESCAPED = 'exception.escaped'
    
        # The exception message.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   Division by zero
        #   Can't convert 'int' object to str implicitly
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::EXCEPTION::EXCEPTION_MESSAGE}.
        EXCEPTION_MESSAGE = 'exception.message'
    
        # A stacktrace as a string in the natural representation for the language runtime. The representation is to be determined and documented by each language SIG.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   Exception in thread "main" java.lang.RuntimeException: Test exception\n at com.example.GenerateTrace.methodB(GenerateTrace.java:13)\n at com.example.GenerateTrace.methodA(GenerateTrace.java:9)\n at com.example.GenerateTrace.main(GenerateTrace.java:5)

        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::EXCEPTION::EXCEPTION_STACKTRACE}.
        EXCEPTION_STACKTRACE = 'exception.stacktrace'
    
        # The type of the exception (its fully-qualified class name, if applicable). The dynamic type of the exception should be preferred over the static type in languages that support it.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   java.net.ConnectException
        #   OSError
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::EXCEPTION::EXCEPTION_TYPE}.
        EXCEPTION_TYPE = 'exception.type'
    
        # @!endgroup
      end
    end
  end
end