# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module ENDUSER
        # @!group Attribute Names
      
        # Unique identifier of an end user in the system. It maybe a username, email address, or other identifier.
        #
        # Unique identifier of an end user in the system.
        #
        # > [!Warning]
        # > This field contains sensitive (PII) information.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   username
        #
        ENDUSER_ID = 'enduser.id'
    
        # Pseudonymous identifier of an end user. This identifier should be a random value that is not directly linked or associated with the end user's actual identity.
        #
        # Pseudonymous identifier of an end user.
        #
        # > [!Warning]
        # > This field contains sensitive (linkable PII) information.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   QdH5CAWJgqVT4rOr0qtumf
        #
        ENDUSER_PSEUDO_ID = 'enduser.pseudo.id'
    
        # Deprecated, use `user.roles` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   admin
        #
        # @deprecated {"note": "Use `user.roles` attribute instead.", "reason": "uncategorized"}
        ENDUSER_ROLE = 'enduser.role'
    
        # Deprecated, no replacement at this time.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   read:message, write:files
        #
        # @deprecated {"note": "Removed, no replacement at this time.", "reason": "obsoleted"}
        ENDUSER_SCOPE = 'enduser.scope'
    
        # @!endgroup
      end
    end
  end
end