# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module DNS
        # @!group Attribute Names
      
        # The list of IPv4 or IPv6 addresses resolved during DNS lookup.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ["10.0.0.1", "2001:0db8:85a3:0000:0000:8a2e:0370:7334"]
        #
        DNS_ANSWERS = 'dns.answers'
    
        # The name being queried.
        #
        # If the name field contains non-printable characters (below 32 or above 126), those characters should be represented as escaped base 10 integers (\DDD). Back slashes and quotes should be escaped. Tabs, carriage returns, and line feeds should be converted to \t, \r, and \n respectively.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   www.example.com
        #   opentelemetry.io
        #
        DNS_QUESTION_NAME = 'dns.question.name'
    
        # @!endgroup
      end
    end
  end
end