# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module DB
        # @!group Attribute Names
      
        # Deprecated, use `cassandra.consistency.level` instead.
        #
        # @note Stability Level: development
        # @deprecated {"note": "Replaced by `cassandra.consistency.level`.", "reason": "renamed", "renamed_to": "cassandra.consistency.level"}
        DB_CASSANDRA_CONSISTENCY_LEVEL = 'db.cassandra.consistency_level'
    
        # Deprecated, use `cassandra.coordinator.dc` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   us-west-2
        #
        # @deprecated {"note": "Replaced by `cassandra.coordinator.dc`.", "reason": "renamed", "renamed_to": "cassandra.coordinator.dc"}
        DB_CASSANDRA_COORDINATOR_DC = 'db.cassandra.coordinator.dc'
    
        # Deprecated, use `cassandra.coordinator.id` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   be13faa2-8574-4d71-926d-27f16cf8a7af
        #
        # @deprecated {"note": "Replaced by `cassandra.coordinator.id`.", "reason": "renamed", "renamed_to": "cassandra.coordinator.id"}
        DB_CASSANDRA_COORDINATOR_ID = 'db.cassandra.coordinator.id'
    
        # Deprecated, use `cassandra.query.idempotent` instead.
        #
        # @note Stability Level: development
        # @deprecated {"note": "Replaced by `cassandra.query.idempotent`.", "reason": "renamed", "renamed_to": "cassandra.query.idempotent"}
        DB_CASSANDRA_IDEMPOTENCE = 'db.cassandra.idempotence'
    
        # Deprecated, use `cassandra.page.size` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   5000
        #
        # @deprecated {"note": "Replaced by `cassandra.page.size`.", "reason": "renamed", "renamed_to": "cassandra.page.size"}
        DB_CASSANDRA_PAGE_SIZE = 'db.cassandra.page_size'
    
        # Deprecated, use `cassandra.speculative_execution.count` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   0
        #   2
        #
        # @deprecated {"note": "Replaced by `cassandra.speculative_execution.count`.", "reason": "renamed", "renamed_to": "cassandra.speculative_execution.count"}
        DB_CASSANDRA_SPECULATIVE_EXECUTION_COUNT = 'db.cassandra.speculative_execution_count'
    
        # Deprecated, use `db.collection.name` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   mytable
        #
        # @deprecated {"note": "Replaced by `db.collection.name`.", "reason": "renamed", "renamed_to": "db.collection.name"}
        DB_CASSANDRA_TABLE = 'db.cassandra.table'
    
        # The name of the connection pool; unique within the instrumented application. In case the connection pool implementation doesn't provide a name, instrumentation SHOULD use a combination of parameters that would make the name unique, for example, combining attributes `server.address`, `server.port`, and `db.namespace`, formatted as `server.address:server.port/db.namespace`. Instrumentations that generate connection pool name following different patterns SHOULD document it.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   myDataSource
        #
        DB_CLIENT_CONNECTION_POOL_NAME = 'db.client.connection.pool.name'
    
        # The state of a connection in the pool
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   idle
        #
        DB_CLIENT_CONNECTION_STATE = 'db.client.connection.state'
    
        # Deprecated, use `db.client.connection.pool.name` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   myDataSource
        #
        # @deprecated {"note": "Replaced by `db.client.connection.pool.name`.", "reason": "renamed", "renamed_to": "db.client.connection.pool.name"}
        DB_CLIENT_CONNECTIONS_POOL_NAME = 'db.client.connections.pool.name'
    
        # Deprecated, use `db.client.connection.state` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   idle
        #
        # @deprecated {"note": "Replaced by `db.client.connection.state`.", "reason": "renamed", "renamed_to": "db.client.connection.state"}
        DB_CLIENT_CONNECTIONS_STATE = 'db.client.connections.state'
    
        # The name of a collection (table, container) within the database.
        #
        # It is RECOMMENDED to capture the value as provided by the application
        # without attempting to do any case normalization.
        #
        # The collection name SHOULD NOT be extracted from `db.query.text`,
        # when the database system supports query text with multiple collections
        # in non-batch operations.
        #
        # For batch operations, if the individual operations are known to have the same
        # collection name then that collection name SHOULD be used.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   public.users
        #   customers
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::DB::DB_COLLECTION_NAME}.
        DB_COLLECTION_NAME = 'db.collection.name'
    
        # Deprecated, use `server.address`, `server.port` attributes instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Server=(localdb)\v11.0;Integrated Security=true;
        #
        # @deprecated {"note": "Replaced by `server.address` and `server.port`.\n", "reason": "uncategorized"}
        DB_CONNECTION_STRING = 'db.connection_string'
    
        # Deprecated, use `azure.client.id` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   3ba4827d-4422-483f-b59f-85b74211c11d
        #
        # @deprecated {"note": "Replaced by `azure.client.id`.", "reason": "renamed", "renamed_to": "azure.client.id"}
        DB_COSMOSDB_CLIENT_ID = 'db.cosmosdb.client_id'
    
        # Deprecated, use `azure.cosmosdb.connection.mode` instead.
        #
        # @note Stability Level: development
        # @deprecated {"note": "Replaced by `azure.cosmosdb.connection.mode`.", "reason": "renamed", "renamed_to": "azure.cosmosdb.connection.mode"}
        DB_COSMOSDB_CONNECTION_MODE = 'db.cosmosdb.connection_mode'
    
        # Deprecated, use `cosmosdb.consistency.level` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Eventual
        #   ConsistentPrefix
        #   BoundedStaleness
        #   Strong
        #   Session
        #
        # @deprecated {"note": "Replaced by `azure.cosmosdb.consistency.level`.", "reason": "renamed", "renamed_to": "azure.cosmosdb.consistency.level"}
        DB_COSMOSDB_CONSISTENCY_LEVEL = 'db.cosmosdb.consistency_level'
    
        # Deprecated, use `db.collection.name` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   mytable
        #
        # @deprecated {"note": "Replaced by `db.collection.name`.", "reason": "renamed", "renamed_to": "db.collection.name"}
        DB_COSMOSDB_CONTAINER = 'db.cosmosdb.container'
    
        # Deprecated, no replacement at this time.
        #
        # @note Stability Level: development
        # @deprecated {"note": "Removed, no replacement at this time.\n", "reason": "obsoleted"}
        DB_COSMOSDB_OPERATION_TYPE = 'db.cosmosdb.operation_type'
    
        # Deprecated, use `azure.cosmosdb.operation.contacted_regions` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ["North Central US", "Australia East", "Australia Southeast"]
        #
        # @deprecated {"note": "Replaced by `azure.cosmosdb.operation.contacted_regions`.", "reason": "renamed", "renamed_to": "azure.cosmosdb.operation.contacted_regions"}
        DB_COSMOSDB_REGIONS_CONTACTED = 'db.cosmosdb.regions_contacted'
    
        # Deprecated, use `azure.cosmosdb.operation.request_charge` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   46.18
        #   1.0
        #
        # @deprecated {"note": "Replaced by `azure.cosmosdb.operation.request_charge`.", "reason": "renamed", "renamed_to": "azure.cosmosdb.operation.request_charge"}
        DB_COSMOSDB_REQUEST_CHARGE = 'db.cosmosdb.request_charge'
    
        # Deprecated, use `azure.cosmosdb.request.body.size` instead.
        #
        # @note Stability Level: development
        # @deprecated {"note": "Replaced by `azure.cosmosdb.request.body.size`.", "reason": "renamed", "renamed_to": "azure.cosmosdb.request.body.size"}
        DB_COSMOSDB_REQUEST_CONTENT_LENGTH = 'db.cosmosdb.request_content_length'
    
        # Deprecated, use `db.response.status_code` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   200
        #   201
        #
        # @deprecated {"note": "Replaced by `db.response.status_code`.", "reason": "renamed", "renamed_to": "db.response.status_code"}
        DB_COSMOSDB_STATUS_CODE = 'db.cosmosdb.status_code'
    
        # Deprecated, use `azure.cosmosdb.response.sub_status_code` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1000
        #   1002
        #
        # @deprecated {"note": "Replaced by `azure.cosmosdb.response.sub_status_code`.", "reason": "renamed", "renamed_to": "azure.cosmosdb.response.sub_status_code"}
        DB_COSMOSDB_SUB_STATUS_CODE = 'db.cosmosdb.sub_status_code'
    
        # Deprecated, use `db.namespace` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   e9106fc68e3044f0b1475b04bf4ffd5f
        #
        # @deprecated {"note": "Replaced by `db.namespace`.", "reason": "renamed", "renamed_to": "db.namespace"}
        DB_ELASTICSEARCH_CLUSTER_NAME = 'db.elasticsearch.cluster.name'
    
        # Deprecated, use `elasticsearch.node.name` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   instance-0000000001
        #
        # @deprecated {"note": "Replaced by `elasticsearch.node.name`.", "reason": "renamed", "renamed_to": "elasticsearch.node.name"}
        DB_ELASTICSEARCH_NODE_NAME = 'db.elasticsearch.node.name'
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   DB_ELASTICSEARCH_PATH_PARTS_LAMBDA.call('some-cool-key') #=> 'db.elasticsearch.path_parts.some-cool-key'
        #
        # Deprecated, use `db.operation.parameter` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   test-index
        #   123
        #
        # @deprecated {"note": "Replaced by `db.operation.parameter`.", "reason": "renamed", "renamed_to": "db.operation.parameter"}
        DB_ELASTICSEARCH_PATH_PARTS_LAMBDA = ->(key) { "db.elasticsearch.path_parts.#{key}" }
    
        # Deprecated, no general replacement at this time. For Elasticsearch, use `db.elasticsearch.node.name` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   mysql-e26b99z.example.com
        #
        # @deprecated {"note": "Removed, no general replacement at this time. For Elasticsearch, use `db.elasticsearch.node.name` instead.\n", "reason": "obsoleted"}
        DB_INSTANCE_ID = 'db.instance.id'
    
        # Removed, no replacement at this time.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   org.postgresql.Driver
        #   com.microsoft.sqlserver.jdbc.SQLServerDriver
        #
        # @deprecated {"note": "Removed, no replacement at this time.\n", "reason": "obsoleted"}
        DB_JDBC_DRIVER_CLASSNAME = 'db.jdbc.driver_classname'
    
        # Deprecated, use `db.collection.name` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   mytable
        #
        # @deprecated {"note": "Replaced by `db.collection.name`.", "reason": "renamed", "renamed_to": "db.collection.name"}
        DB_MONGODB_COLLECTION = 'db.mongodb.collection'
    
        # Deprecated, SQL Server instance is now populated as a part of `db.namespace` attribute.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   MSSQLSERVER
        #
        # @deprecated {"note": "Removed, no replacement at this time.", "reason": "obsoleted"}
        DB_MSSQL_INSTANCE_NAME = 'db.mssql.instance_name'
    
        # Deprecated, use `db.namespace` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   customers
        #   main
        #
        # @deprecated {"note": "Replaced by `db.namespace`.", "reason": "renamed", "renamed_to": "db.namespace"}
        DB_NAME = 'db.name'
    
        # The name of the database, fully qualified within the server address and port.
        #
        # If a database system has multiple namespace components, they SHOULD be concatenated from the most general to the most specific namespace component, using `|` as a separator between the components. Any missing components (and their associated separators) SHOULD be omitted.
        # Semantic conventions for individual database systems SHOULD document what `db.namespace` means in the context of that system.
        # It is RECOMMENDED to capture the value as provided by the application without attempting to do any case normalization.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   customers
        #   test.users
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::DB::DB_NAMESPACE}.
        DB_NAMESPACE = 'db.namespace'
    
        # Deprecated, use `db.operation.name` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   findAndModify
        #   HMSET
        #   SELECT
        #
        # @deprecated {"note": "Replaced by `db.operation.name`.", "reason": "renamed", "renamed_to": "db.operation.name"}
        DB_OPERATION = 'db.operation'
    
        # The number of queries included in a batch operation.
        #
        # Operations are only considered batches when they contain two or more operations, and so `db.operation.batch.size` SHOULD never be `1`.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   2
        #   3
        #   4
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::DB::DB_OPERATION_BATCH_SIZE}.
        DB_OPERATION_BATCH_SIZE = 'db.operation.batch.size'
    
        # The name of the operation or command being executed.
        #
        # It is RECOMMENDED to capture the value as provided by the application
        # without attempting to do any case normalization.
        #
        # The operation name SHOULD NOT be extracted from `db.query.text`,
        # when the database system supports query text with multiple operations
        # in non-batch operations.
        #
        # If spaces can occur in the operation name, multiple consecutive spaces
        # SHOULD be normalized to a single space.
        #
        # For batch operations, if the individual operations are known to have the same operation name
        # then that operation name SHOULD be used prepended by `BATCH `,
        # otherwise `db.operation.name` SHOULD be `BATCH` or some other database
        # system specific term if more applicable.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   findAndModify
        #   HMSET
        #   SELECT
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::DB::DB_OPERATION_NAME}.
        DB_OPERATION_NAME = 'db.operation.name'
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   DB_OPERATION_PARAMETER_LAMBDA.call('some-cool-key') #=> 'db.operation.parameter.some-cool-key'
        #
        # A database operation parameter, with `<key>` being the parameter name, and the attribute value being a string representation of the parameter value.
        #
        # For example, a client-side maximum number of rows to read from the database
        # MAY be recorded as the `db.operation.parameter.max_rows` attribute.
        #
        # `db.query.text` parameters SHOULD be captured using `db.query.parameter.<key>`
        # instead of `db.operation.parameter.<key>`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   someval
        #   55
        #
        DB_OPERATION_PARAMETER_LAMBDA = ->(key) { "db.operation.parameter.#{key}" }
    
        # Must be called with a key for the full attribute name. See notes below about the expectations
        # for the state of the key.
        #
        # @example Usage
        #   DB_QUERY_PARAMETER_LAMBDA.call('some-cool-key') #=> 'db.query.parameter.some-cool-key'
        #
        # A database query parameter, with `<key>` being the parameter name, and the attribute value being a string representation of the parameter value.
        #
        # If a query parameter has no name and instead is referenced only by index,
        # then `<key>` SHOULD be the 0-based index.
        #
        # `db.query.parameter.<key>` SHOULD match
        # up with the parameterized placeholders present in `db.query.text`.
        #
        # `db.query.parameter.<key>` SHOULD NOT be captured on batch operations.
        #
        # Examples:
        #
        # - For a query `SELECT * FROM users where username =  %s` with the parameter `"jdoe"`,
        #   the attribute `db.query.parameter.0` SHOULD be set to `"jdoe"`.
        # - For a query `"SELECT * FROM users WHERE username = %(username)s;` with parameter
        #   `username = "jdoe"`, the attribute `db.query.parameter.username` SHOULD be set to `"jdoe"`.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   someval
        #   55
        #
        DB_QUERY_PARAMETER_LAMBDA = ->(key) { "db.query.parameter.#{key}" }
    
        # Low cardinality summary of a database query.
        #
        # The query summary describes a class of database queries and is useful
        # as a grouping key, especially when analyzing telemetry for database
        # calls involving complex queries.
        #
        # Summary may be available to the instrumentation through
        # instrumentation hooks or other means. If it is not available, instrumentations
        # that support query parsing SHOULD generate a summary following
        # [Generating query summary](/docs/database/database-spans.md#generating-a-summary-of-the-query)
        # section.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   SELECT wuser_table
        #   INSERT shipping_details SELECT orders
        #   get user by id
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::DB::DB_QUERY_SUMMARY}.
        DB_QUERY_SUMMARY = 'db.query.summary'
    
        # The database query being executed.
        #
        # For sanitization see [Sanitization of `db.query.text`](/docs/database/database-spans.md#sanitization-of-dbquerytext).
        # For batch operations, if the individual operations are known to have the same query text then that query text SHOULD be used, otherwise all of the individual query texts SHOULD be concatenated with separator `; ` or some other database system specific separator if more applicable.
        # Parameterized query text SHOULD NOT be sanitized. Even though parameterized query text can potentially have sensitive data, by using a parameterized query the user is giving a strong signal that any sensitive data will be passed as parameter values, and the benefit to observability of capturing the static part of the query text by default outweighs the risk.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   SELECT * FROM wuser_table where username = ?
        #   SET mykey ?
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::DB::DB_QUERY_TEXT}.
        DB_QUERY_TEXT = 'db.query.text'
    
        # Deprecated, use `db.namespace` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   0
        #   1
        #   15
        #
        # @deprecated {"note": "Replaced by `db.namespace`.", "reason": "renamed", "renamed_to": "db.namespace"}
        DB_REDIS_DATABASE_INDEX = 'db.redis.database_index'
    
        # Number of rows returned by the operation.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   10
        #   30
        #   1000
        #
        DB_RESPONSE_RETURNED_ROWS = 'db.response.returned_rows'
    
        # Database response status code.
        #
        # The status code returned by the database. Usually it represents an error code, but may also represent partial success, warning, or differentiate between various types of successful outcomes.
        # Semantic conventions for individual database systems SHOULD document what `db.response.status_code` means in the context of that system.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   102
        #   ORA-17002
        #   08P01
        #   404
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::DB::DB_RESPONSE_STATUS_CODE}.
        DB_RESPONSE_STATUS_CODE = 'db.response.status_code'
    
        # Deprecated, use `db.collection.name` instead.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   mytable
        #
        # @deprecated {"note": "Replaced by `db.collection.name`, but only if not extracting the value from `db.query.text`.", "reason": "uncategorized"}
        DB_SQL_TABLE = 'db.sql.table'
    
        # The database statement being executed.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   SELECT * FROM wuser_table
        #   SET mykey "WuValue"
        #
        # @deprecated {"note": "Replaced by `db.query.text`.", "reason": "renamed", "renamed_to": "db.query.text"}
        DB_STATEMENT = 'db.statement'
    
        # The name of a stored procedure within the database.
        #
        # It is RECOMMENDED to capture the value as provided by the application
        # without attempting to do any case normalization.
        #
        # For batch operations, if the individual operations are known to have the same
        # stored procedure name then that stored procedure name SHOULD be used.
        #
        # @note Stability Level: stable
        #
        # @example Sample Values
        #   GetCustomer
        #
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::DB::DB_STORED_PROCEDURE_NAME}.
        DB_STORED_PROCEDURE_NAME = 'db.stored_procedure.name'
    
        # Deprecated, use `db.system.name` instead.
        #
        # @note Stability Level: development
        # @deprecated {"note": "Replaced by `db.system.name`.", "reason": "renamed", "renamed_to": "db.system.name"}
        DB_SYSTEM = 'db.system'
    
        # The database management system (DBMS) product as identified by the client instrumentation.
        #
        # The actual DBMS may differ from the one identified by the client. For example, when using PostgreSQL client libraries to connect to a CockroachDB, the `db.system.name` is set to `postgresql` based on the instrumentation's best knowledge.
        #
        # @note Stability Level: stable
        #
        # @deprecated Now available in the stable namespace at {OpenTelemetry::SemConv::DB::DB_SYSTEM_NAME}.
        DB_SYSTEM_NAME = 'db.system.name'
    
        # Deprecated, no replacement at this time.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   readonly_user
        #   reporting_user
        #
        # @deprecated {"note": "Removed, no replacement at this time.", "reason": "obsoleted"}
        DB_USER = 'db.user'
    
        # @!endgroup
      end
    end
  end
end