# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module CLOUD
        # @!group Attribute Names
      
        # The cloud account ID the resource is assigned to.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   111111111111
        #   opentelemetry
        #
        CLOUD_ACCOUNT_ID = 'cloud.account.id'
    
        # Cloud regions often have multiple, isolated locations known as zones to increase availability. Availability zone represents the zone where the resource is running.
        #
        # Availability zones are called "zones" on Alibaba Cloud and Google Cloud.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   us-east-1c
        #
        CLOUD_AVAILABILITY_ZONE = 'cloud.availability_zone'
    
        # The cloud platform in use.
        #
        # The prefix of the service SHOULD match the one specified in `cloud.provider`.
        #
        # @note Stability Level: development
        CLOUD_PLATFORM = 'cloud.platform'
    
        # Name of the cloud provider.
        #
        # @note Stability Level: development
        CLOUD_PROVIDER = 'cloud.provider'
    
        # The geographical region within a cloud provider. When associated with a resource, this attribute specifies the region where the resource operates. When calling services or APIs deployed on a cloud, this attribute identifies the region where the called destination is deployed.
        #
        # Refer to your provider's docs to see the available regions, for example [Alibaba Cloud regions](https://www.alibabacloud.com/help/doc-detail/40654.htm), [AWS regions](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/), [Azure regions](https://azure.microsoft.com/global-infrastructure/geographies/), [Google Cloud regions](https://cloud.google.com/about/locations), or [Tencent Cloud regions](https://www.tencentcloud.com/document/product/213/6091).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   us-central1
        #   us-east-1
        #
        CLOUD_REGION = 'cloud.region'
    
        # Cloud provider-specific native identifier of the monitored cloud resource (e.g. an [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) on AWS, a [fully qualified resource ID](https://learn.microsoft.com/rest/api/resources/resources/get-by-id) on Azure, a [full resource name](https://google.aip.dev/122#full-resource-names) on GCP)
        #
        # On some cloud providers, it may not be possible to determine the full ID at startup,
        # so it may be necessary to set `cloud.resource_id` as a span attribute instead.
        #
        # The exact value to use for `cloud.resource_id` depends on the cloud provider.
        # The following well-known definitions MUST be used if you set this attribute and they apply:
        #
        # - **AWS Lambda:** The function [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
        #   Take care not to use the "invoked ARN" directly but replace any
        #   [alias suffix](https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html)
        #   with the resolved function version, as the same runtime instance may be invocable with
        #   multiple different aliases.
        # - **GCP:** The [URI of the resource](https://cloud.google.com/iam/docs/full-resource-names)
        # - **Azure:** The [Fully Qualified Resource ID](https://learn.microsoft.com/rest/api/resources/resources/get-by-id) of the invoked function,
        #   *not* the function app, having the form
        #   `/subscriptions/<SUBSCRIPTION_GUID>/resourceGroups/<RG>/providers/Microsoft.Web/sites/<FUNCAPP>/functions/<FUNC>`.
        #   This means that a span attribute MUST be used, as an Azure function app can host multiple functions that would usually share
        #   a TracerProvider.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   arn:aws:lambda:REGION:ACCOUNT_ID:function:my-function
        #   //run.googleapis.com/projects/PROJECT_ID/locations/LOCATION_ID/services/SERVICE_ID
        #   /subscriptions/<SUBSCRIPTION_GUID>/resourceGroups/<RG>/providers/Microsoft.Web/sites/<FUNCAPP>/functions/<FUNC>
        #
        CLOUD_RESOURCE_ID = 'cloud.resource_id'
    
        # @!endgroup
      end
    end
  end
end