# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module AZURE
        # @!group Attribute Names
      
        # The unique identifier of the client instance.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   3ba4827d-4422-483f-b59f-85b74211c11d
        #   storage-client-1
        #
        AZURE_CLIENT_ID = 'azure.client.id'
    
        # Cosmos client connection mode.
        #
        # @note Stability Level: development
        AZURE_COSMOSDB_CONNECTION_MODE = 'azure.cosmosdb.connection.mode'
    
        # Account or request [consistency level](https://learn.microsoft.com/azure/cosmos-db/consistency-levels).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Eventual
        #   ConsistentPrefix
        #   BoundedStaleness
        #   Strong
        #   Session
        #
        AZURE_COSMOSDB_CONSISTENCY_LEVEL = 'azure.cosmosdb.consistency.level'
    
        # List of regions contacted during operation in the order that they were contacted. If there is more than one region listed, it indicates that the operation was performed on multiple regions i.e. cross-regional call.
        #
        # Region name matches the format of `displayName` in [Azure Location API](https://learn.microsoft.com/rest/api/subscription/subscriptions/list-locations?view=rest-subscription-2021-10-01&tabs=HTTP#location)
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   ["North Central US", "Australia East", "Australia Southeast"]
        #
        AZURE_COSMOSDB_OPERATION_CONTACTED_REGIONS = 'azure.cosmosdb.operation.contacted_regions'
    
        # The number of request units consumed by the operation.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   46.18
        #   1.0
        #
        AZURE_COSMOSDB_OPERATION_REQUEST_CHARGE = 'azure.cosmosdb.operation.request_charge'
    
        # Request payload size in bytes.
        #
        # @note Stability Level: development
        AZURE_COSMOSDB_REQUEST_BODY_SIZE = 'azure.cosmosdb.request.body.size'
    
        # Cosmos DB sub status code.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1000
        #   1002
        #
        AZURE_COSMOSDB_RESPONSE_SUB_STATUS_CODE = 'azure.cosmosdb.response.sub_status_code'
    
        # [Azure Resource Provider Namespace](https://learn.microsoft.com/azure/azure-resource-manager/management/azure-services-resource-providers) as recognized by the client.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   Microsoft.Storage
        #   Microsoft.KeyVault
        #   Microsoft.ServiceBus
        #
        AZURE_RESOURCE_PROVIDER_NAMESPACE = 'azure.resource_provider.namespace'
    
        # The unique identifier of the service request. It's generated by the Azure service and returned with the response.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   00000000-0000-0000-0000-000000000000
        #
        AZURE_SERVICE_REQUEST_ID = 'azure.service.request.id'
    
        # @!endgroup
      end
    end
  end
end