# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module ARTIFACT
        # @!group Attribute Names
      
        # The provenance filename of the built attestation which directly relates to the build artifact filename. This filename SHOULD accompany the artifact at publish time. See the [SLSA Relationship](https://slsa.dev/spec/v1.0/distributing-provenance#relationship-between-artifacts-and-attestations) specification for more information.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   golang-binary-amd64-v0.1.0.attestation
        #   docker-image-amd64-v0.1.0.intoto.json1
        #   release-1.tar.gz.attestation
        #   file-name-package.tar.gz.intoto.json1
        #
        ARTIFACT_ATTESTATION_FILENAME = 'artifact.attestation.filename'
    
        # The full [hash value (see glossary)](https://nvlpubs.nist.gov/nistpubs/FIPS/NIST.FIPS.186-5.pdf), of the built attestation. Some envelopes in the [software attestation space](https://github.com/in-toto/attestation/tree/main/spec) also refer to this as the **digest**.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   1b31dfcd5b7f9267bf2ff47651df1cfb9147b9e4df1f335accf65b4cda498408
        #
        ARTIFACT_ATTESTATION_HASH = 'artifact.attestation.hash'
    
        # The id of the build [software attestation](https://slsa.dev/attestation-model).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   123
        #
        ARTIFACT_ATTESTATION_ID = 'artifact.attestation.id'
    
        # The human readable file name of the artifact, typically generated during build and release processes. Often includes the package name and version in the file name.
        #
        # This file name can also act as the [Package Name](https://slsa.dev/spec/v1.0/terminology#package-model)
        # in cases where the package ecosystem maps accordingly.
        # Additionally, the artifact [can be published](https://slsa.dev/spec/v1.0/terminology#software-supply-chain)
        # for others, but that is not a guarantee.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   golang-binary-amd64-v0.1.0
        #   docker-image-amd64-v0.1.0
        #   release-1.tar.gz
        #   file-name-package.tar.gz
        #
        ARTIFACT_FILENAME = 'artifact.filename'
    
        # The full [hash value (see glossary)](https://nvlpubs.nist.gov/nistpubs/FIPS/NIST.FIPS.186-5.pdf), often found in checksum.txt on a release of the artifact and used to verify package integrity.
        #
        # The specific algorithm used to create the cryptographic hash value is
        # not defined. In situations where an artifact has multiple
        # cryptographic hashes, it is up to the implementer to choose which
        # hash value to set here; this should be the most secure hash algorithm
        # that is suitable for the situation and consistent with the
        # corresponding attestation. The implementer can then provide the other
        # hash values through an additional set of attribute extensions as they
        # deem necessary.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   9ff4c52759e2c4ac70b7d517bc7fcdc1cda631ca0045271ddd1b192544f8a3e9
        #
        ARTIFACT_HASH = 'artifact.hash'
    
        # The [Package URL](https://github.com/package-url/purl-spec) of the [package artifact](https://slsa.dev/spec/v1.0/terminology#package-model) provides a standard way to identify and locate the packaged artifact.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   pkg:github/package-url/purl-spec@1209109710924
        #   pkg:npm/foo@12.12.3
        #
        ARTIFACT_PURL = 'artifact.purl'
    
        # The version of the artifact.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   v0.1.0
        #   1.2.1
        #   122691-build
        #
        ARTIFACT_VERSION = 'artifact.version'
    
        # @!endgroup
      end
    end
  end
end