# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module Incubating
      module ANDROID
        # @!group Attribute Names
      
        # This attribute represents the state of the application.
        #
        # The Android lifecycle states are defined in [Activity lifecycle callbacks](https://developer.android.com/guide/components/activities/activity-lifecycle#lc), and from which the `OS identifiers` are derived.
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   created
        #
        ANDROID_APP_STATE = 'android.app.state'
    
        # Uniquely identifies the framework API revision offered by a version (`os.version`) of the android operating system. More information can be found [here](https://developer.android.com/guide/topics/manifest/uses-sdk-element#ApiLevels).
        #
        # @note Stability Level: development
        #
        # @example Sample Values
        #   33
        #   32
        #
        ANDROID_OS_API_LEVEL = 'android.os.api_level'
    
        # Deprecated. Use `android.app.state` body field instead.
        #
        # @note Stability Level: development
        # @deprecated {"note": "Use `android.app.state` body field instead.", "reason": "uncategorized"}
        ANDROID_STATE = 'android.state'
    
        # @!endgroup
      end
    end
  end
end