# frozen_string_literal: true

# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#
# This file was autogenerated. Do not edit it by hand.

module OpenTelemetry
  module SemConv
    module ERROR
      # @!group Attribute Names
    
      # Describes a class of error the operation ended with.
      #
      # The `error.type` SHOULD be predictable, and SHOULD have low cardinality.
      #
      # When `error.type` is set to a type (e.g., an exception type), its
      # canonical class name identifying the type within the artifact SHOULD be used.
      #
      # Instrumentations SHOULD document the list of errors they report.
      #
      # The cardinality of `error.type` within one instrumentation library SHOULD be low.
      # Telemetry consumers that aggregate data from multiple instrumentation libraries and applications
      # should be prepared for `error.type` to have high cardinality at query time when no
      # additional filters are applied.
      #
      # If the operation has completed successfully, instrumentations SHOULD NOT set `error.type`.
      #
      # If a specific domain defines its own set of error identifiers (such as HTTP or gRPC status codes),
      # it's RECOMMENDED to:
      #
      # - Use a domain-specific attribute
      # - Set `error.type` to capture all errors, regardless of whether they are defined within the domain-specific set or not.
      #
      # @note Stability Level: stable
      #
      # @example Sample Values
      #   timeout
      #   java.net.UnknownHostException
      #   server_certificate_invalid
      #   500
      #
      ERROR_TYPE = 'error.type'
  
      # @!endgroup
    end
  end
end