type Maybe<T> = T | undefined | null;
type EmojiVersion = '0.6' | '0.7' | '1.0' | '2.0' | '3.0' | '4.0' | '5.0' | '11.0' | '12.0' | '12.1' | '13.0' | '13.1' | '14.0' | '15.0' | '15.1';
type CodePoint = string;
type Emoji = {
    emoji: string;
    components?: Maybe<Array<string>>;
    description?: Maybe<string>;
    version: EmojiVersion;
    keywords?: Maybe<Array<string>>;
    codePoint?: Maybe<CodePoint>;
    codePoints?: Maybe<Array<CodePoint>>;
    category?: Maybe<string>;
    group?: Maybe<string>;
    subgroup?: Maybe<string>;
    variations?: Maybe<Array<Emoji>>;
};
type Group = 'category' | 'group' | 'subgroup';
/**
 * Check whether a value is a valid Emoji Version
 * @param version - Version
 * @returns
 */
declare function isValidEmojiVersion(version: any): version is EmojiVersion;
/**
 * Get All Emojis as an array of emoji character
 * @param emojis
 * @returns
 */
declare function getAllEmojis(emojis?: Array<Emoji>): string[];
declare function compareVersion(a: EmojiVersion, b: EmojiVersion, exact?: boolean): boolean;
/**
 * Filter Emoijs by the Unicode Version
 * @param version
 * @param exact
 * @param emoijs
 * @returns
 */
declare function filterEmojis(version: EmojiVersion, exact?: boolean, emoijs?: Array<Emoji>): Emoji[];
/**
 * Get Emojis by group, category or subgroup
 * @param group category | group | subgroup
 * @param emojis
 * @returns
 */
declare function getEmojisByGroup(group: Group, emojis?: Array<Emoji>): Map<string, Emoji[]>;
/**
 * Get Unicode Emoji Components
 * @returns
 */
declare function getAllComponents(): Record<string, Emoji[]>;
/**
 * Emoji Regular Expression
 * @returns Emoji Regex
 */
declare function getEmojiRegex(): RegExp;
/**
 * Check whether a given text has emojis
 * @param text
 * @returns text has emojis
 */
declare function hasEmoji(text: string): boolean;
/**
 * Extract Emojis in a given text and preserve the order of appearance
 * @param text
 * @returns
 */
declare function extractEmojis(text: string): string[];
/**
 * Strip / Remove Emojis in a given text
 * @param text
 * @returns
 */
declare function stripEmojies(text: string): string;

export { Emoji, EmojiVersion, compareVersion, extractEmojis, filterEmojis, getAllComponents, getAllEmojis, getEmojiRegex, getEmojisByGroup, hasEmoji, isValidEmojiVersion, stripEmojies };
