import Abstract from './layers/abstract';
import type Tensor from './tensor';
import type { NeuralNetworkLayersDescriptions, NeuralNetworkLayersResolved, NeuralNetworkOptions, ParamsAndGrads, Precision } from './types';
declare class NeuralNetwork {
    layers: NeuralNetworkLayersResolved;
    options: NeuralNetworkOptions;
    constructor(options: NeuralNetworkOptions);
    cost(input: Tensor, output: Tensor): number;
    forward(input: Tensor, isTraining: boolean): Tensor;
    backward(output: Tensor): number;
    resolve(layers: NeuralNetworkLayersDescriptions): Abstract[];
    getAsOptions(precision?: Precision): NeuralNetworkOptions;
    getParamsAndGrads(): ParamsAndGrads[];
}
export default NeuralNetwork;
