import AbstractHidden from './abstract_hidden';
import Tensor from '../tensor';
import type Abstract from './abstract';
import type { ConvOptions, ParamsAndGrads, Precision } from '../types';
declare class Conv extends AbstractHidden<ConvOptions> {
    sx: number;
    sy: number;
    stride: number;
    pad: number;
    bias: number;
    l1decay: number;
    l2decay: number;
    biased: boolean;
    biases: Tensor;
    filters: Tensor[];
    constructor(options: ConvOptions, prev?: Abstract);
    forward(input: Tensor, isTraining: boolean): Tensor;
    backward(): void;
    getAsOptions(precision: Precision): ConvOptions;
    getParamsAndGrads(): ParamsAndGrads[];
}
export default Conv;
