import type Tensor from '../tensor';
import type { AbstractOptions, ParamsAndGrads, Precision } from '../types';
declare class Abstract<T extends AbstractOptions = AbstractOptions> {
    options: T;
    isx: number;
    isy: number;
    isz: number;
    il: number;
    it: Tensor;
    osx: number;
    osy: number;
    osz: number;
    ot: Tensor;
    constructor(options: T, prev?: Abstract);
    forward(input: Tensor, isTraining: boolean): Tensor;
    backward(output: any): any;
    getAsOptions(precision: Precision): T;
    getParamsAndGrads(): ParamsAndGrads[];
}
export default Abstract;
