// NOTICE: This file is generated by Rollup. To modify it,
// please instead edit the ESM counterpart and rebuild with Rollup (npm run build).
'use strict';

const valueParser = require('postcss-value-parser');
const validateTypes = require('../../utils/validateTypes.cjs');
const nodeFieldIndices = require('../../utils/nodeFieldIndices.cjs');
const findNotContiguousOrRectangular = require('./utils/findNotContiguousOrRectangular.cjs');
const isStandardSyntaxValue = require('../../utils/isStandardSyntaxValue.cjs');
const report = require('../../utils/report.cjs');
const ruleMessages = require('../../utils/ruleMessages.cjs');
const validateOptions = require('../../utils/validateOptions.cjs');

const ruleName = 'named-grid-areas-no-invalid';

const messages = ruleMessages(ruleName, {
	expectedToken: () => 'Expected cell token within string',
	expectedSameNumber: () => 'Expected same number of cell tokens in each string',
	expectedRectangle: (name) => `Expected single filled-in rectangle for "${name}"`,
});

const meta = {
	url: 'https://stylelint.io/user-guide/rules/named-grid-areas-no-invalid',
};

/** @type {import('stylelint').CoreRules[ruleName]} */
const rule = (primary) => {
	return (root, result) => {
		const validOptions = validateOptions(result, ruleName, { actual: primary });

		if (!validOptions) {
			return;
		}

		root.walkDecls(/^(?:grid|grid-template|grid-template-areas)$/i, (decl) => {
			const { value } = decl;

			if (!isStandardSyntaxValue(value)) return;

			if (value.toLowerCase().trim() === 'none') return;

			/** @type {Array<{ values: string[], index: number, endIndex: number }>} */
			const areas = [];
			let reportSent = false;

			valueParser(value).walk(({ sourceIndex, sourceEndIndex, type, value: tokenValue }) => {
				if (type !== 'string') return;

				if (tokenValue === '') {
					complain(messages.expectedToken, [], sourceIndex, sourceEndIndex);
					reportSent = true;

					return;
				}

				areas.push({
					values: tokenValue.trim().split(' ').filter(Boolean),
					index: sourceIndex,
					endIndex: sourceEndIndex,
				});
			});

			if (reportSent) return;

			const [firstArea] = areas;

			if (firstArea === undefined) return;

			const notSameNumberArea = areas.find(
				(area) => area.values.length !== firstArea.values.length,
			);

			if (notSameNumberArea !== undefined) {
				complain(
					messages.expectedSameNumber,
					[],
					notSameNumberArea.index,
					notSameNumberArea.endIndex,
				);

				return;
			}

			const notContiguousOrRectangular = findNotContiguousOrRectangular(areas.map((a) => a.values));

			for (const name of notContiguousOrRectangular.sort()) {
				const area = areas.find((a) => a.values.includes(name));

				validateTypes.assert(area);
				complain(messages.expectedRectangle, [name], area.index, area.endIndex);
			}

			/**
			 * @param {typeof messages[keyof messages]} message
			 * @param {Array<string>} messageArgs
			 * @param {number} index
			 * @param {number} endIndex
			 */
			function complain(message, messageArgs, index, endIndex) {
				const start = nodeFieldIndices.declarationValueIndex(decl);

				report({
					message,
					messageArgs,
					node: decl,
					index: start + index,
					endIndex: start + endIndex,
					result,
					ruleName,
				});
			}
		});
	};
};

rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;

module.exports = rule;
