// NOTICE: This file is generated by Rollup. To modify it,
// please instead edit the ESM counterpart and rebuild with Rollup (npm run build).
'use strict';

const typeGuards = require('../../utils/typeGuards.cjs');
const isStandardSyntaxRule = require('../../utils/isStandardSyntaxRule.cjs');
const report = require('../../utils/report.cjs');
const ruleMessages = require('../../utils/ruleMessages.cjs');
const validateOptions = require('../../utils/validateOptions.cjs');

const ruleName = 'block-no-redundant-nested-style-rules';

const messages = ruleMessages(ruleName, {
	rejected: 'Unexpected redundant nested style rule',
});

const meta = {
	url: 'https://stylelint.io/user-guide/rules/block-no-redundant-nested-style-rules',
};

/** @type {import('stylelint').CoreRules[ruleName]} */
const rule = (primary) => {
	return (root, result) => {
		const validOptions = validateOptions(result, ruleName, {
			actual: primary,
			possible: [true],
		});

		if (!validOptions) return;

		root.walkRules((ruleNode) => {
			if (!isStandardSyntaxRule(ruleNode)) return;

			const { parent, selector } = ruleNode;

			if (selector !== '&') return;

			if (!parent) return;

			if (typeGuards.isRoot(parent)) return;

			report({
				message: messages.rejected,
				messageArgs: [],
				node: ruleNode,
				result,
				ruleName,
			});
		});
	};
};

rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;

module.exports = rule;
