import { MessageFormatElement } from '@formatjs/icu-messageformat-parser';
import { TSESTree } from '@typescript-eslint/utils';
import { RuleContext } from '@typescript-eslint/utils/ts-eslint';
export interface MessageDescriptor {
    id?: string;
    defaultMessage?: string;
    description?: string | object;
}
export interface Settings {
    excludeMessageDeclCalls?: boolean;
    additionalFunctionNames?: string[];
    additionalComponentNames?: string[];
    ignoreTag?: boolean;
}
export interface MessageDescriptorNodeInfo {
    message: MessageDescriptor;
    messageNode?: TSESTree.Property['value'] | TSESTree.JSXAttribute['value'];
    messagePropNode?: TSESTree.Property | TSESTree.JSXAttribute;
    descriptionNode?: TSESTree.Property['value'] | TSESTree.JSXAttribute['value'];
    idValueNode?: TSESTree.Property['value'] | TSESTree.JSXAttribute['value'];
    idPropNode?: TSESTree.Property | TSESTree.JSXAttribute;
}
export declare function getSettings<TMessageIds extends string, TOptions extends readonly unknown[]>({ settings }: RuleContext<TMessageIds, TOptions>): Settings;
export declare function isIntlFormatMessageCall(node: TSESTree.Node): node is TSESTree.CallExpression;
export declare function extractMessageDescriptor(node?: TSESTree.Expression): MessageDescriptorNodeInfo | undefined;
export declare function extractMessages(node: TSESTree.Node, { additionalComponentNames, additionalFunctionNames, excludeMessageDeclCalls, }?: Settings): Array<[MessageDescriptorNodeInfo, TSESTree.Expression | undefined]>;
/**
 * Apply changes to the ICU message in code. The return value can be used in
 * `fixer.replaceText(messageNode, <return value>)`. If the return value is null,
 * it means that the patch cannot be applied.
 */
export declare function patchMessage(messageNode: TSESTree.Node, ast: MessageFormatElement[], patcher: (messageContent: string, ast: MessageFormatElement[]) => string): string | null;
