"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rule = exports.name = exports.Option = void 0;
const context_compat_1 = require("../context-compat");
const util_1 = require("../util");
var Option;
(function (Option) {
    Option["literal"] = "literal";
    Option["anything"] = "anything";
})(Option || (exports.Option = Option = {}));
function checkNode(context, node) {
    const msgs = (0, util_1.extractMessages)(node, (0, util_1.getSettings)(context));
    const { options: [type], } = context;
    for (const [{ message: { description }, descriptionNode, },] of msgs) {
        if (!description) {
            if (type === 'literal' && descriptionNode) {
                context.report({
                    node: descriptionNode,
                    messageId: 'enforceDescriptionLiteral',
                });
            }
            else if (!descriptionNode) {
                context.report({
                    node: node,
                    messageId: 'enforceDescription',
                });
            }
        }
    }
}
exports.name = 'enforce-description';
exports.rule = {
    meta: {
        type: 'problem',
        docs: {
            description: 'Enforce description in message descriptor',
            url: 'https://formatjs.github.io/docs/tooling/linter#enforce-description',
        },
        fixable: 'code',
        schema: [
            {
                type: 'string',
                enum: Object.keys(Option),
            },
        ],
        messages: {
            enforceDescription: '`description` has to be specified in message descriptor',
            enforceDescriptionLiteral: '`description` has to be a string literal (not function call or variable)',
        },
    },
    defaultOptions: [],
    create(context) {
        const callExpressionVisitor = (node) => checkNode(context, node);
        const parserServices = (0, context_compat_1.getParserServices)(context);
        //@ts-expect-error defineTemplateBodyVisitor exists in Vue parser
        if (parserServices?.defineTemplateBodyVisitor) {
            //@ts-expect-error
            return parserServices.defineTemplateBodyVisitor({
                CallExpression: callExpressionVisitor,
            }, {
                CallExpression: callExpressionVisitor,
            });
        }
        return {
            JSXOpeningElement: (node) => checkNode(context, node),
            CallExpression: callExpressionVisitor,
        };
    },
};
