import { getParserServices } from '../context-compat';
import { extractMessages, getSettings } from '../util';
export var Option;
(function (Option) {
    Option["literal"] = "literal";
    Option["anything"] = "anything";
})(Option || (Option = {}));
function checkNode(context, node) {
    const msgs = extractMessages(node, getSettings(context));
    const { options: [type], } = context;
    for (const [{ message: { description }, descriptionNode, },] of msgs) {
        if (!description) {
            if (type === 'literal' && descriptionNode) {
                context.report({
                    node: descriptionNode,
                    messageId: 'enforceDescriptionLiteral',
                });
            }
            else if (!descriptionNode) {
                context.report({
                    node: node,
                    messageId: 'enforceDescription',
                });
            }
        }
    }
}
export const name = 'enforce-description';
export const rule = {
    meta: {
        type: 'problem',
        docs: {
            description: 'Enforce description in message descriptor',
            url: 'https://formatjs.github.io/docs/tooling/linter#enforce-description',
        },
        fixable: 'code',
        schema: [
            {
                type: 'string',
                enum: Object.keys(Option),
            },
        ],
        messages: {
            enforceDescription: '`description` has to be specified in message descriptor',
            enforceDescriptionLiteral: '`description` has to be a string literal (not function call or variable)',
        },
    },
    defaultOptions: [],
    create(context) {
        const callExpressionVisitor = (node) => checkNode(context, node);
        const parserServices = getParserServices(context);
        //@ts-expect-error defineTemplateBodyVisitor exists in Vue parser
        if (parserServices?.defineTemplateBodyVisitor) {
            //@ts-expect-error
            return parserServices.defineTemplateBodyVisitor({
                CallExpression: callExpressionVisitor,
            }, {
                CallExpression: callExpressionVisitor,
            });
        }
        return {
            JSXOpeningElement: (node) => checkNode(context, node),
            CallExpression: callExpressionVisitor,
        };
    },
};
